//
//  TCGBShowTermsViewResult.h
//  Gamebase
//
//  Created by NHN on 2022/01/26.
//  Copyright © 2022 NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Gamebase/TCGBValueObject.h>

NS_ASSUME_NONNULL_BEGIN

@class TCGBPushConfiguration;
@class TCGBDataContainer;

@interface TCGBShowTermsViewResult : NSObject <TCGBValueObject>

@property (nonatomic, assign) BOOL isTermsUIOpened;
@property (nonatomic, strong, nullable) TCGBPushConfiguration *pushConfiguration;

+ (nullable instancetype)fromDataContainer:(TCGBDataContainer *)dataContainer
    NS_SWIFT_NAME(fromDataContainer(_:));

- (NSString *)jsonString
    NS_SWIFT_NAME(jsonString());

- (NSString *)prettyJsonString
    NS_SWIFT_NAME(prettyJsonString());

@end

NS_ASSUME_NONNULL_END
