//
//  TCGBPurchasableRetryTransactionResult.h
//  Gamebase
//
//  Created by Philip Chung on 2023/02/16
//  Copyright © 2023 NHN Corp. All rights reserved.
//
        

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class TCGBPurchasableReceipt;

/** The TCGBPurchasableRetryTransactionResult class represent a result after retrying failed purchasing processes.
 */
@interface TCGBPurchasableRetryTransactionResult : NSObject

/**---------------------------------------------------------------------------------------
 * @name Properties
 *  ---------------------------------------------------------------------------------------
 */

/** successList
 
 This array contains results of successed receipt. Each receipt is implemented by `TCGBPurchasableReceipt`.
 */
@property (nonatomic, strong) NSArray<TCGBPurchasableReceipt *> *successList;

/** failList
 
 This array contains results of failed receipt. Each receipt is implemented by `TCGBPurchasableReceipt`.
 */
@property (nonatomic, strong) NSArray<TCGBPurchasableReceipt *> *failList;

/**---------------------------------------------------------------------------------------
 * @name Allocation
 *  ---------------------------------------------------------------------------------------
 */

/** Initialize the class with JSON Value.
 
 @param result      result is a json formatted NSDictionary object. This is from NHN Cloud IAP Server.
 @return Instance being initialized.
 */
+ (instancetype)purchasableTransactionResultWithResult:(NSDictionary<NSString *, id> *)result
    NS_SWIFT_NAME(purchasableTransactionResult(_:));

@end


NS_ASSUME_NONNULL_END
