//
//  TCGBLaunching.h
//  Gamebase
//
//  Created by NHN on 2016. 6. 27..
//  © NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <Gamebase/TCGBError.h>

#ifndef TCGBLaunching_h
#define TCGBLaunching_h

/// JSONPath for Launching Informations

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, TCGBLaunchingStatus) {
    IN_SERVICE = 200,
    RECOMMEND_UPDATE = 201,
    IN_SERVICE_BY_QA_WHITE_LIST = 202,
    IN_TEST = 203,
    IN_REVIEW = 204,
    IN_BETA = 205,
    
    REQUIRE_UPDATE = 300,
    BLOCKED_USER = 301,
    TERMINATED_SERVICE = 302,
    INSPECTING_SERVICE = 303,               // 상태 및 Raw Data를 모두 넘겨줄 수 있을 경우
    INSPECTING_ALL_SERVICES = 304,   // 상태만 넘겨줄 수 있을 경우
    
    INTERNAL_SERVER_ERROR = 500,
    
//    UNREGISTERED_GAME = 400,              // 400 대 에러는 TCGBError 로 설정
//    UNREGISTERED_CLIENT = 401,
};

// launching정보에서 statuscode가 변경되었을 때만 Noti해줌.
extern NSString* const kTCGBLaunchingStatusCodeChangedNotification;

typedef void(^launchingCompletion)(id _Nullable launchingData, TCGBError * _Nullable error);
typedef void(^changedStatusNotificationHandler)(NSDictionary * _Nullable launchingStatus);

// Philip: TODO: 최소지원버전 iOS 13으로 올라가면 Actor 적용하자
/** The TCGBLaunching class contains several informations that is received from the server after application is successfully launched.
 */
@interface TCGBLaunching : NSObject
{
    NSMutableArray*             _statusNotificationHandlers;
    NSDictionary*               _launchingStatusData;
    NSDate*                     _dateOfLastUpdatedStatus;
    TCGBLaunchingStatus          _launchingStatus;
    
    BOOL                        _registeredScheduleForStatus;
    NSTimer*                    _refreshTimer;
    launchingCompletion         _completionHandler;
    
    NSDictionary*               _launchingInformations;
    NSDictionary*               _TCGBLaunchingInformations;
    NSArray*                    _TCIAPInformations;
    NSString*                   _TCLaunchingInformations;
    NSDictionary*               _TCProductInformations;
    BOOL                        _serverShowTermsFlag;
    
    /**
     Last Checked Notification Time. Notification could be set in the NHN Cloud Console.
     */
    NSNumber*                   _lastLCNT;
}

/**---------------------------------------------------------------------------------------
 * @name Launching Information
 *  ---------------------------------------------------------------------------------------
 */

/**
 @return Launching Status which indicates whether the application is playable or not.
 @see TCGBLaunchingStatus
 */
+ (TCGBLaunchingStatus)launchingStatus
    NS_SWIFT_NAME(launchingStatus());

/**
 @return All Launching Information from the server.
 */
+ (nullable NSDictionary<NSString *, id> *)launchingInformations
    NS_SWIFT_NAME(launchingInformations());

/**
 @return Launching Information related with TCGB launching service.
 */
+ (nullable NSDictionary<NSString *, id> *)TCGBLaunchingInformations
    NS_SWIFT_NAME(TCGBLaunchingInformations());

/**
 @return Launching Information related with NHN Cloud product.
 */
+ (nullable NSDictionary<NSString *, id> *)tcProductInformations
    NS_SWIFT_NAME(tcProductInformations());

/**
 @return Launching Information related with NHN Cloud launching.
 */
+ (nullable NSString *)tcLaunchingInformations
    NS_SWIFT_NAME(tcLaunchingInformations());

/**
 @return Launching Information related with NHN Cloud IAP.
 */
+ (nullable NSArray<NSDictionary<NSString *, id> *> *)tcIAPInformations
    NS_SWIFT_NAME(tcIAPInformations());
@end

NS_ASSUME_NONNULL_END

#endif // TCGBLaunching_h
