//
//  TCGBGamebaseEventHandler.h
//  Gamebase
//
//  Created by NHNEnt on 2020/05/14.
//  Copyright © 2020 NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Gamebase/TCGBValueObject.h>
#import <Gamebase/TCGBConstants.h>

NS_ASSUME_NONNULL_BEGIN

#pragma mark - TCGBGamebaseEventMessage VO
@interface TCGBGamebaseEventMessage : NSObject <TCGBValueObject>

@property (nonatomic, strong)  NSString* category;
@property (nonatomic, strong, nullable) NSString* data;

+ (TCGBGamebaseEventMessage *)gamebaseEventMessageWithCategory:(TCGBGamebaseEventCategory)category data:(NSString * _Nullable)data
    NS_SWIFT_NAME(gamebaseEventMessage(category:data:));

+ (TCGBGamebaseEventMessage *)gamebaseEventMessageFromJsonString:(NSString * _Nullable)jsonString
    NS_SWIFT_NAME(gamebaseEventMessage(jsonString:));

@end


#pragma mark - TCGBGamebaseEventServerPushData VO
@interface TCGBGamebaseEventServerPushData : NSObject <TCGBValueObject>

@property (nonatomic, strong, nullable) NSDictionary<NSString *, id> *popup;
@property (nonatomic, strong, nullable) NSString* extras;

+ (TCGBGamebaseEventServerPushData *)gamebaseEventServerPushDataWithPopup:(NSDictionary<NSString *, id> * _Nullable)popup extras:(NSString * _Nullable)extras
    NS_SWIFT_NAME(gamebaseEventServerPushData(popup:extras:));

+ (TCGBGamebaseEventServerPushData *)gamebaseEventServerPushDataFromJsonString:(NSString * _Nullable)jsonString
    NS_SWIFT_NAME(gamebaseEventServerPushData(jsonString:));

@end


#pragma mark - TCGBGamebaseEventObserverData VO
@interface TCGBGamebaseEventObserverData : NSObject <TCGBValueObject>

@property (nonatomic, assign)           int64_t     code;
@property (nonatomic, strong, nullable) NSString*   message;
@property (nonatomic, strong, nullable) NSString*   extras;

+ (TCGBGamebaseEventObserverData *)gamebaseEventObserverDataWithCode:(int64_t)code message:(NSString * _Nullable)message extras:(NSString * _Nullable)extras
    NS_SWIFT_NAME(gamebaseEventObserverData(code:message:extras:));

+ (TCGBGamebaseEventObserverData *)gamebaseEventObserverDataFromJsonString:(nullable NSString *)jsonString
    NS_SWIFT_NAME(gamebaseEventObserverData(jsonString:));

@end

#pragma mark - TCGBPushMessage VO
@interface TCGBPushMessage : NSObject <TCGBValueObject>

@property (nonatomic, strong,) NSString* identifier;
@property (nonatomic, strong, nullable) NSString* title;
@property (nonatomic, strong, nullable) NSString* body;
@property (nonatomic, strong) NSString* extras;

+ (TCGBPushMessage *)pushMessageFromJsonString:(nullable NSString *)jsonString
    NS_SWIFT_NAME(pushMessage(jsonString:));

@end

#pragma mark - TCGBPushAction VO
@interface TCGBPushAction : NSObject <TCGBValueObject>

@property (nonatomic, strong) NSString* actionType;
@property (nonatomic, strong, nullable) TCGBPushMessage* message;
@property (nonatomic, strong, nullable) NSString* userText;

+ (TCGBPushAction *)pushActionFromJsonString:(nullable NSString *)jsonString
    NS_SWIFT_NAME(pushAction(jsonString:));

@end

#pragma mark - TCGBGamebaseEventLoggedOutData VO
@interface TCGBGamebaseEventLoggedOutData : NSObject <TCGBValueObject>

@property (nonatomic, strong, nullable) NSString*   message;
@property (nonatomic, strong, nullable) NSString*   extras;

+ (instancetype)gamebaseEventLoggedOutDataWithMessage:(nullable NSString *)message extras:(nullable NSString *)extras
    NS_SWIFT_NAME(gamebaseEventLoggedOutData(message:extras:));

+ (instancetype)gamebaseEventLoggedOutDataFromJsonString:(nullable NSString *)jsonString
    NS_SWIFT_NAME(gamebaseEventLoggedOutData(jsonString:));

@end

#pragma mark - TCGBGamebaseEventIdPRevokedData VO
@interface TCGBGamebaseEventIdPRevokedData : NSObject <TCGBValueObject>

@property (nonatomic, assign) int64_t                 code;
@property (nonatomic, strong) NSString*               idPType;
@property (nonatomic, strong) NSArray<NSString *>*    authMappingList;
@property (nonatomic, strong) NSString*               extras;

+ (instancetype)gamebaseEventIdPRevokedDataFromJsonString:(nullable NSString *)jsonString
    NS_SWIFT_NAME(gamebaseEventIdPRevokedData(jsonString:));

@end

NS_ASSUME_NONNULL_END
