//
//  TCGBGameNotice.h
//  Gamebase
//
//  Created by NHN on 3/12/25.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class TCGBError;
@class TCGBGameNoticeConfiguration;

@interface TCGBGameNotice: NSObject

/// Open GameNotice.
/// - Parameters:
///   - viewController: represent to current viewcontroller.
///   - completion: completion may call when finished showing gameNotice.
+ (void)openGameNoticeWithViewController:(nullable UIViewController *)viewController
                              completion:(nullable void(^)(TCGBError * _Nullable))completion
    NS_SWIFT_NAME(openGameNotice(viewController:completion:));

/// Open GameNotice.
/// - Parameters:
///   - viewController: represent to current viewcontroller.
///   - configuration: This configuration applies to the behavior of the gameNotice.
///   - completion: completion may call when finished showing gameNotice.
+ (void)openGameNoticeWithViewController:(nullable UIViewController *)viewController
                           configuration:(TCGBGameNoticeConfiguration *)configuration
                              completion:(nullable void(^)(TCGBError * _Nullable))completion
    NS_SWIFT_NAME(openGameNotice(viewController:configuration:completion:));

@end

NS_ASSUME_NONNULL_END
