//
//  TCGBDataContainer.h
//  Gamebase
//
//  Created by NHN on 2021/01/07.
//  Copyright © 2021 NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Gamebase/TCGBValueObject.h>

NS_ASSUME_NONNULL_BEGIN

@interface TCGBDataContainer : NSObject <TCGBValueObject>

@property (nonatomic, strong) NSString *data;

+ (instancetype)dataContainerWithData:(NSString *)data
    NS_SWIFT_NAME(dataContainer(data:));

- (NSString *)description
    NS_SWIFT_NAME(description());

- (NSString *)debugDescription
    NS_SWIFT_NAME(debugDescription());

- (NSString *)jsonString
    NS_SWIFT_NAME(jsonString());

- (NSString *)prettyJsonString
    NS_SWIFT_NAME(prettyJsonString());

@end

NS_ASSUME_NONNULL_END
