//
//  TCGBConstants.h
//  Gamebase
//
//  Created by NHN on 2016. 5. 25..
//  © NHN Corp. All rights reserved.
//

#ifndef TCGBConstants_h
#define TCGBConstants_h

#define TCGB_SUCCESS   nil

NS_ASSUME_NONNULL_BEGIN

#pragma mark - TCGBAppDelegate
extern NSString* const kTCGBAppDelegateNotificationDidBecomeActive;
extern NSString* const kTCGBAppDelegateNotificationWillFinishLaunchingWithOptions;
extern NSString* const kTCGBAppDelegateNotificationWillEnterForeground;
extern NSString* const kTCGBAppDelegateNotificationWillResignActive;
extern NSString* const kTCGBAppDelegateNotificationDidEnterBackground;
extern NSString* const kTCGBAppDelegateNotificationWillTerminate;
extern NSString* const kTCGBAppDelegateNotificationOpenURL;


#pragma mark - TCGBAuthIDPs
extern NSString* const kTCGBAuthGuest;
extern NSString* const kTCGBAuthFacebook;
extern NSString* const kTCGBAuthiOSGameCenter;
extern NSString* const kTCGBAuthNaver;
extern NSString* const kTCGBAuthTwitter;
extern NSString* const kTCGBAuthGoogle;
extern NSString* const kTCGBAuthLine;
extern NSString* const kTCGBAuthAppleID;
extern NSString* const kTCGBAuthHangame;
extern NSString* const kTCGBAuthWeibo;
extern NSString* const kTCGBAuthKakaogame;
extern NSString* const kTCGBAuthSteam;
extern NSString* const kTCGBAuthEpicgames;

#pragma mark - TCGBAuthAdditionalInfos
extern NSString* const kTCGBAuthAdditionalInfo;
extern NSString* const kTCGBAuthAdditionalInfoFacebookAccessToken;
extern NSString* const kTCGBAuthAdditionalInfoAppleidAuthCode;
extern NSString* const kTCGBAuthConsoleAuthKeyname;
extern NSString* const kTCGBAuthAdditionalInfoSkipIdPLogoutKeyname;
extern NSString* const kTCGBAuthAdditionalInfoSkipExpireGamebaseTokenKeyname;
extern NSString* const kTCGBAuthAdditionalInfoIsInternalCallKeyname;

#pragma mark - Credential Information for loginWithCredential
extern NSString* const kTCGBAuthLoginWithCredentialSubCodeKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialLineChannelRegionKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialProviderNameKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialClientIdKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialAccessTokenKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialAccessTokenSecretKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialRefreshTokenKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialThirdIdPCode;
extern NSString* const kTCGBAuthLoginWithCredentialGamebaseAccessTokenKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialIgnoreAlreadyLoggedInKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialCodeVerifierKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialAuthorizationCodeKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialAuthorizationProtocolKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialExtraParamsKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialVerificationTypeKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialProfileApiVersionKeyname;
extern NSString* const kTCGBAuthLoginWithCredentialAuthExtraKeyname DEPRECATED_MSG_ATTRIBUTE("Use kTCGBAuthLoginWithCredentialExtraParamsKeyname instead.");

#pragma mark - WebView Event Notification
extern NSString* const kTCGBWebViewControllerNotificationClose;

#pragma mark - DisplayLanguageCode
extern NSString* const kTCGBDisplayLanguageCodeGerman;
extern NSString* const kTCGBDisplayLanguageCodeEnglish;
extern NSString* const kTCGBDisplayLanguageCodeSpanish;
extern NSString* const kTCGBDisplayLanguageCodeFinnish;
extern NSString* const kTCGBDisplayLanguageCodeFrench;
extern NSString* const kTCGBDisplayLanguageCodeIndonesian;
extern NSString* const kTCGBDisplayLanguageCodeItalian;
extern NSString* const kTCGBDisplayLanguageCodeJapanese;
extern NSString* const kTCGBDisplayLanguageCodeKorean;
extern NSString* const kTCGBDisplayLanguageCodePortuguese;
extern NSString* const kTCGBDisplayLanguageCodeRussian;
extern NSString* const kTCGBDisplayLanguageCodeThai;
extern NSString* const kTCGBDisplayLanguageCodeVietnamese;
extern NSString* const kTCGBDisplayLanguageCodeMalay;
extern NSString* const kTCGBDisplayLanguageCodeChineseSimplified;
extern NSString* const kTCGBDisplayLanguageCodeChineseTraditional;

#pragma mark - Server Push Types
extern NSString* const kTCGBServerPushNotificationTypeAppKickout;
extern NSString* const kTCGBServerPushNotificationTypeTransferKickout;
extern NSString* const kTCGBServerPushNotificationTypeAppKickoutMessageReceived;

#pragma mark - Observer Message Types
extern NSString* const kTCGBObserverMessageTypeNetwork;                 // Network Monitoring (NotReachable, ReachableViaWifi, ReachableViaWWAN);
extern NSString* const kTCGBObserverMessageTypeLaunching;               // Launching Status (TCGBLaunchingStatus)
extern NSString* const kTCGBObserverMessageTypeHeartbeat;               // Heartbeat (Banned User: TCGB_ERROR_BANNED_MEMBER)

#pragma mark - GamebaseEventHandler
typedef NSString *TCGBGamebaseEventCategory NS_STRING_ENUM;
extern TCGBGamebaseEventCategory const kTCGBServerPushAppKickout;
extern TCGBGamebaseEventCategory const kTCGBServerPushTransferKickout;
extern TCGBGamebaseEventCategory const kTCGBServerPushAppKickoutMessageReceived;
extern TCGBGamebaseEventCategory const kTCGBObserverLaunching;
extern TCGBGamebaseEventCategory const kTCGBObserverNetwork;
extern TCGBGamebaseEventCategory const kTCGBObserverHeartbeat;
extern TCGBGamebaseEventCategory const kTCGBPurchaseUpdated;
extern TCGBGamebaseEventCategory const kTCGBPushReceivedMessage;
extern TCGBGamebaseEventCategory const kTCGBPushClickMessage;
extern TCGBGamebaseEventCategory const kTCGBPushClickAction;
extern TCGBGamebaseEventCategory const kTCGBLoggedOut;
extern TCGBGamebaseEventCategory const kTCGBIdPRevoked;

#pragma mark - GamebaseEventHandler (IdP Revoked Codes)
typedef NS_ENUM(NSInteger, TCGBIdPRevokedCode) {
    IDP_REVOKED_WITHDRAW = 600,
    IDP_REVOKED_OVERWRITE_LOGIN_AND_REMOVE_MAPPING = 601,
    IDP_REVOKED_REMOVE_MAPPING = 602,
};

#pragma mark - TCGBError Codes
typedef NS_ENUM(NSInteger, TCGBErrorCode) {
    // Common
    TCGB_ERROR_NOT_INITIALIZED                           = 1,
    TCGB_ERROR_NOT_LOGGED_IN                             = 2,
    TCGB_ERROR_INVALID_PARAMETER                         = 3,
    TCGB_ERROR_INVALID_JSON_FORMAT                       = 4,
    TCGB_ERROR_USER_PERMISSION                           = 5,
    TCGB_ERROR_INVALID_MEMBER                            = 6,
    TCGB_ERROR_BANNED_MEMBER                             = 7,
    TCGB_ERROR_SAME_REQUESTOR                            = 8,
    TCGB_ERROR_NOT_GUEST_OR_HAS_OTHERS                   = 9,
    
    TCGB_ERROR_NOT_SUPPORTED                             = 10,
    TCGB_ERROR_NOT_SUPPORTED_ANDROID                     = 11,              // <UNITY ONLY>
    TCGB_ERROR_NOT_SUPPORTED_IOS                         = 12,              // <UNITY ONLY>
    TCGB_ERROR_NOT_SUPPORTED_UNITY_EDITOR                = 13,              // <UNITY ONLY>
    TCGB_ERROR_NOT_SUPPORTED_UNITY_STANDALONE            = 14,              // <UNITY ONLY>
    TCGB_ERROR_NOT_SUPPORTED_UNITY_WEBGL                 = 15,              // <UNITY ONLY>
    TCGB_ERROR_ANDROID_ACTIVITY_DESTROYED                = 31,              // <ANDROID ONLY>
    TCGB_ERROR_ANDROID_ACTIVEAPP_NOT_CALLED              = 32,              // <ANDROID ONLY>
    TCGB_ERROR_IOS_GAMECENTER_DENIED                     = 51,              // <IOS ONLY>
    TCGB_ERROR_IOS_CANNOT_OPEN_URL                       = 52,              // <IOS ONLY>
    
    // Network (Socket)
    TCGB_ERROR_SOCKET_RESPONSE_TIMEOUT                   = 101,
    TCGB_ERROR_SOCKET_ERROR                              = 110,
    
    TCGB_ERROR_SOCKET_UNKNOWN_ERROR                      = 999,
    
    // Launching
    TCGB_ERROR_LAUNCHING_SERVER_ERROR                    = 2001,
    TCGB_ERROR_LAUNCHING_NOT_EXIST_CLIENT_ID             = 2002,
    TCGB_ERROR_LAUNCHING_UNREGISTERED_APP                = 2003,
    TCGB_ERROR_LAUNCHING_UNREGISTERED_CLIENT             = 2004,

    // Auth
    // common
    TCGB_ERROR_AUTH_USER_CANCELED                         = 3001,
    TCGB_ERROR_AUTH_NOT_SUPPORTED_PROVIDER                = 3002,
    TCGB_ERROR_AUTH_NOT_EXIST_MEMBER                      = 3003,
    TCGB_ERROR_AUTH_EXTERNAL_LIBRARY_INITIALIZATION_ERROR = 3006,
    
    TCGB_ERROR_AUTH_EXTERNAL_LIBRARY_ERROR               = 3009,
    TCGB_ERROR_AUTH_ALREADY_IN_PROGRESS_ERROR            = 3010,
    TCGB_ERROR_AUTH_INVALID_GAMEBASE_TOKEN               = 3011,
    TCGB_ERROR_AUTH_AUTHENTICATION_SERVER_ERROR          = 3012,
    // TransferAccount
    TCGB_ERROR_AUTH_TRANSFERACCOUNT_EXPIRED              = 3041,
    TCGB_ERROR_AUTH_TRANSFERACCOUNT_BLOCK                = 3042,
    TCGB_ERORR_AUTH_TRANSFERACCOUNT_INVALID_ID           = 3043,
    TCGB_ERORR_AUTH_TRANSFERACCOUNT_INVALID_PASSWORD     = 3044,
    TCGB_ERROR_AUTH_TRANSFERACCOUNT_CONSOLE_NO_CONDITION = 3045,
    TCGB_ERROR_AUTH_TRANSFERACCOUNT_NOT_EXIST            = 3046,
    TCGB_ERROR_AUTH_TRANSFERACCOUNT_ALREADY_EXIST_ID     = 3047,
    TCGB_ERROR_AUTH_TRANSFERACCOUNT_ALREADY_USED         = 3048,
    
    // tokenLogin
    TCGB_ERROR_AUTH_TOKEN_LOGIN_FAILED                     = 3101,
    TCGB_ERROR_AUTH_TOKEN_LOGIN_INVALID_TOKEN_INFO         = 3102,
    TCGB_ERROR_AUTH_TOKEN_LOGIN_INVALID_LAST_LOGGED_IN_IDP = 3103,
    // idPLogin
    TCGB_ERROR_AUTH_IDP_LOGIN_FAILED                     = 3201,
    TCGB_ERROR_AUTH_IDP_LOGIN_INVALID_IDP_INFO           = 3202,
    TCGB_ERROR_AUTH_IDP_LOGIN_EXTERNAL_AUTHENTICATION_REQUIRED  = 3203,
    
    // addMapping
    TCGB_ERROR_AUTH_ADD_MAPPING_FAILED                         = 3301,
    TCGB_ERROR_AUTH_ADD_MAPPING_ALREADY_MAPPED_TO_OTHER_MEMBER = 3302,
    TCGB_ERROR_AUTH_ADD_MAPPING_ALREADY_HAS_SAME_IDP           = 3303,
    TCGB_ERROR_AUTH_ADD_MAPPING_INVALID_IDP_INFO               = 3304,
    TCGB_ERROR_AUTH_ADD_MAPPING_CANNOT_ADD_GUEST_IDP           = 3305,
    // forceMapping
    TCGB_ERROR_AUTH_ADD_MAPPING_FORCIBLY_NOT_EXIST_KEY     = 3311,
    TCGB_ERROR_AUTH_ADD_MAPPING_FORCIBLY_ALREADY_USED_KEY  = 3312,
    TCGB_ERROR_AUTH_ADD_MAPPING_FORCIBLY_EXPIRED_KEY       = 3313,
    TCGB_ERROR_AUTH_ADD_MAPPING_FORCIBLY_DIFFERENT_IDP     = 3314,
    TCGB_ERROR_AUTH_ADD_MAPPING_FORCIBLY_DIFFERENT_AUTHKEY = 3315,
    // removeMapping
    TCGB_ERROR_AUTH_REMOVE_MAPPING_FAILED                = 3401,
    TCGB_ERROR_AUTH_REMOVE_MAPPING_LAST_MAPPED_IDP       = 3402,
    TCGB_ERROR_AUTH_REMOVE_MAPPING_LOGGED_IN_IDP         = 3403,
    // logout
    TCGB_ERROR_AUTH_LOGOUT_FAILED                        = 3501,
    // withdraw
    TCGB_ERROR_AUTH_WITHDRAW_FAILED                      = 3601,
    TCGB_ERROR_AUTH_WITHDRAW_ALREADY_TEMPORARY_WITHDRAW  = 3602,
    TCGB_ERROR_AUTH_WITHDRAW_NOT_TEMPORARY_WITHDRAW      = 3603,
    // status not playable
    TCGB_ERROR_AUTH_NOT_PLAYABLE                         = 3701,            // 상태 별 로직은 launchingStatus를 확인하여 처리
    // unknown
    TCGB_ERROR_AUTH_UNKNOWN_ERROR                        = 3999,
    
    // Purchase
    TCGB_ERROR_PURCHASE_NOT_INITIALIZED                  = 4001,
    TCGB_ERROR_PURCHASE_USER_CANCELED                    = 4002,
    TCGB_ERROR_PURCHASE_NOT_FINISHED_PREVIOUS_PURCHASING = 4003,
    TCGB_ERROR_PURCHASE_NOT_ENOUGH_CASH                  = 4004,
    TCGB_ERROR_PURCHASE_INACTIVE_PRODUCT_ID              = 4005,
    TCGB_ERROR_PURCHASE_NOT_EXIST_PRODUCT_ID             = 4006,
    TCGB_ERROR_PURCHASE_LIMIT_EXCEEDED                   = 4007,
    
    
    TCGB_ERROR_PURCHASE_NOT_SUPPORTED_MARKET             = 4010,
    
    TCGB_ERROR_PURCHASE_EXTERNAL_LIBRARY_ERROR           = 4201,
    
    TCGB_ERROR_PURCHASE_UNKNOWN_ERROR                    = 4999,
    
    // Push
    TCGB_ERROR_PUSH_EXTERNAL_LIBRARY_ERROR               = 5101,
    TCGB_ERROR_PUSH_ALREADY_IN_PROGRESS_ERROR            = 5102,
    
    TCGB_ERROR_PUSH_UNKNOWN_ERROR                        = 5999,
    
    // Logger
    TCGB_ERROR_LOGGER_NOT_INITIALIZED                    = 6001,
    TCGB_ERROR_LOGGER_EXTERNAL_LIBRARY_ERROR             = 6048,
    TCGB_ERROR_LOGGER_UNKNOWN_ERROR                      = 6049,
    
    // UI
    TCGB_ERROR_UI_IMAGE_NOTICE_TIMEOUT                   = 6901,
    TCGB_ERROR_UI_CONTACT_FAIL_INVALID_URL               = 6911,
    TCGB_ERROR_UI_CONTACT_FAIL_ISSUE_SHORT_TERM_TICKET   = 6912,
    
    // Terms
    TCGB_ERROR_UI_TERMS_NOT_EXIST_IN_CONSOLE             = 6921,
    TCGB_ERROR_UI_TERMS_NOT_EXIST_FOR_DEVICE_COUNTRY     = 6922,
    TCGB_ERROR_UI_TERMS_UNREGISTERED_SEQ                 = 6923,
    TCGB_ERROR_UI_TERMS_ALREADY_IN_PROGRESS_ERROR        = 6924,
    
    // GameNotice
    TCGB_ERROR_UI_GAME_NOTICE_FAIL_INVALID_URL           = 6941,
    
    TCGB_ERROR_UI_UNKNOWN_ERROR                          = 6999,
    
    // WebView
    TCGB_ERROR_WEBVIEW_INVALID_URL                       = 7001,
    TCGB_ERROR_WEBVIEW_TIMEOUT                           = 7002,
    TCGB_ERROR_WEBVIEW_HTTP_ERROR                        = 7003,
    TCGB_ERROR_WEBVIEW_UNKNOWN_ERROR                     = 7999,              // <UNITY ONLY>
    
    // Server
    TCGB_ERROR_SERVER_INTERNAL_ERROR                     = 8001,
    TCGB_ERROR_SERVER_REMOTE_SYSTEM_ERROR                = 8002,
    TCGB_ERROR_SERVER_INVALID_RESPONSE                   = 8003,
    TCGB_ERROR_SERVER_UNKNOWN_ERROR                      = 8999,
    
    // Unknown
    TCGB_ERROR_UNKNOWN_ERROR                             = 9999,
    
    // Platform specified errors
    TCGB_ERROR_INVALID_INTERNAL_STATE                    = 11001,
    TCGB_ERROR_NOT_CALLABLE_STATE                        = 11002,
};

typedef NS_ENUM(NSInteger, NetworkStatus) {
    ReachabilityIsNotDefined = -100,
    NotReachable = -1,
    ReachableViaWWAN,
    ReachableViaWifi,
};

typedef NS_ENUM(NSInteger, GamebaseToastLength) {
    GamebaseToastLengthShort = 0,
    GamebaseToastLengthLong = 1,
};

NS_ASSUME_NONNULL_END

#endif /* TCGBConstants_h */
