//
//  TCGBConfiguration.h
//  Gamebase
//
//  Created by NHN on 2016. 12. 28..
//  © NHN Corp. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

extern NSString* const kStoreCodeAppStore;
extern NSString* const kConfigurationShowBlockingPopup;
extern NSString* const kConfigurationLaunchingStatusShowBlockingPopup;
extern NSString* const kConfigurationBanShowBlockingPopup;
extern NSString* const kConfigurationKickoutShowBlockingPopup;

extern NSString* const kConfigurationDisplayLanguageCode;

/** TCGBConfiguration configures essential Gamebase settings.
 */
@interface TCGBConfiguration : NSObject

/**---------------------------------------------------------------------------------------
 * @name Properties
 *  ---------------------------------------------------------------------------------------
 */

/**
 ApplicationID which is NHN Cloud Project ID.
 */
@property (nonatomic, strong) NSString* appID;

/**
 Application Version that is registered at NHN Cloud Console.
 */
@property (nonatomic, strong) NSString* appVersion;

/**
 Zone Type that is nomally "REAL".
 */
@property (nonatomic, strong) NSString* zoneType;

/**
 Server Address which your application communicates with.
 */
@property (nonatomic, strong, readonly) NSURL* serverAddress;

/**
 Extra Options such as whether Showing Blocking PopUp enabled or not.
 */
@property (nonatomic, strong) NSMutableDictionary<NSString *, id>* options;

/**---------------------------------------------------------------------------------------
 * @name Initialization
 *  ---------------------------------------------------------------------------------------
 */

/**
 Creates TCGBConfiguration instance
 
 @param appID ApplicationID which is NHN Cloud Project ID.
 @param appVersion Application Version that is registered at NHN Cloud Console.
 */
+ (TCGBConfiguration *)configurationWithAppID:(NSString *)appID appVersion:(NSString *)appVersion
    NS_SWIFT_NAME(configuration(appID:appVersion:));

/**
 Creates TCGBConfiguration instance
 
 @param appID ApplicationID which is NHN Cloud Project ID.
 @param appVersion Application Version that is registered at NHN Cloud Console.
 @param zoneType Zone Type that is nomally "REAL". It is only used to NHN Cloud Beta/Alaha Test.
 */
+ (TCGBConfiguration *)configurationWithAppID:(NSString *)appID appVersion:(NSString *)appVersion zoneType:(NSString *)zoneType
    NS_SWIFT_NAME(configuration(appID:appVersion:zoneType:));

/**---------------------------------------------------------------------------------------
 * @name Setting Options
 *  ---------------------------------------------------------------------------------------
 */

/**
 Enable Show Blocking PopUp.
 Default set value is enable status popup.
 
 @param enable `YES` if Shown Popup blocking another processes.
 */
- (void)enablePopup:(BOOL)enable
    NS_SWIFT_NAME(enablePopup(_:));

/**
 Method that returns whether the popup will be show or not.
 
 @return Boolean value that whether the popup will be show.
 */
- (BOOL)isEnablePopup
    NS_SWIFT_NAME(isEnablePopup());

/**
 Enable Show Blocking PopUp.
 Default set value is enable status popup.
 
 @param enable `YES` if Shown Popup blocking another processes.
 */
- (void)enableLaunchingStatusPopup:(BOOL)enable
    NS_SWIFT_NAME(enableLaunchingStatusPopup(_:));

/**
 Method that returns whether the popup will be show or not.
 
 @return Boolean value that whether the popup will be show.
 */
- (BOOL)isEnableLaunchingStatusPopup
    NS_SWIFT_NAME(isEnableLaunchingStatusPopup());

/**
 Enable Show Blocking PopUp.
 Default set value is enable status popup.
 
@param enable `YES` if Shown Popup blocking another processes.
*/
- (void)enableBanPopup:(BOOL)enable
    NS_SWIFT_NAME(enableBanPopup(_:));

/**
 Method that returns whether the popup will be show or not.
 
 @return Boolean value that whether the popup will be show.
 */
- (BOOL)isEnableBanPopup
    NS_SWIFT_NAME(isEnableBanPopup());

/**
 StoreCode that is needed when using purchasing APIs.
 
 @param storeCode   It represent storeCode, actually "AS"(AppStore).
 @warning           If you did not set this value, default will set to AS(AppStore).
 */
- (void)setStoreCode:(NSString *)storeCode
    NS_SWIFT_NAME(setStoreCode(_:));

/**
 @return    StoreCode that is needed when using purchasing APIs.
 */
- (NSString *)storeCode
    NS_SWIFT_NAME(storeCode());

/**
@return    String value of gameEngine.
*/
- (NSString *)gameEngine
    NS_SWIFT_NAME(gameEngine());

/**
 Set Display Language Code when initializing Gamebase SDK.
 
 @param languageCode    It represent language code (ISO-639)
 */
- (void)setDisplayLanguageCode:(NSString *)languageCode
    NS_SWIFT_NAME(setDisplayLanguageCode(_:));

/**
 Method that returns displayLanguage that you have set.
 
 @return String value of language code (ISO-639)
 */
- (NSString *)displayLanguageCode
    NS_SWIFT_NAME(displayLanguageCode());

@end

@interface TCGBConfiguration (deprecated)

/**
 @since Added 2.34.0.
 @deprecated As of release 2.34.0, this API is not used anymore.
 */
- (void)enableKickoutPopup:(BOOL)enable DEPRECATED_MSG_ATTRIBUTE("This API is not used anymore.");

/**
 @since Added 2.34.0.
 @deprecated As of release 2.34.0, this API is not used anymore.
 */
- (BOOL)isEnableKickoutPopup DEPRECATED_MSG_ATTRIBUTE("This API is not used anymore.");

@end

NS_ASSUME_NONNULL_END
