//
//  TCGBCommunity.h
//  Gamebase
//
//  Created by NHN on 4/22/24.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class TCGBError;
@class TCGBCommunityConfiguration;

@interface TCGBCommunity: NSObject

/// Request Showing Community.
/// - Parameters:
///   - viewController: represent to current viewcontroller.
///   - configuration: This configuration applies to the behavior of the community.
///   - completion: completion may call when finished showing community.
+ (void)openCommunityWithViewController:(nullable UIViewController *)viewController
                          configuration:(TCGBCommunityConfiguration *)configuration
                             completion:(nullable void(^)(TCGBError * _Nullable))completion
    NS_SWIFT_NAME(openCommunity(viewController:configuration:completion:));

@end

NS_ASSUME_NONNULL_END
