//
//  TCGBAnalyticsGameUserData.h
//  Gamebase
//
//  Created by NHN on 21/11/2018.
//  © NHN Corp. All rights reserved.
//
#import <Foundation/Foundation.h>
#import <Gamebase/TCGBValueObject.h>

#ifndef TCGBAnalyticsGameUserData_h
#define TCGBAnalyticsGameUserData_h

NS_ASSUME_NONNULL_BEGIN

@interface TCGBAnalyticsGameUserData : NSObject <TCGBValueObject>

// Property
@property (nonatomic, assign) int userLevel; // Required.
@property (nonatomic, strong, nullable) NSString* channelId; // Optional. Default value is nil. Accept only positive values.
@property (nonatomic, strong, nullable) NSString* characterId; // Optional. Default value is nil.
@property (nonatomic, strong, nullable) NSString* classId; // Optional. Default value is nil.

// Initializer
- (instancetype)init __attribute__((unavailable("Must use initWithUserLevel: instead.")))
    NS_SWIFT_NAME(init());

- (instancetype)initWithUserLevel:(int)userLevel
    NS_SWIFT_NAME(init(userLevel:));

+ (instancetype)gameUserDataWithUserLevel:(int)userLevel
    NS_SWIFT_NAME(gameUserData(userLevel:));

@end

NS_ASSUME_NONNULL_END

#endif /* TCGBAnalyticsGameUserData_h */
