//
//  TCGBAuthWeiboToken.h
//  GamebaseAuthWeiboAdapter
//
//  Created by NHN on 2020/12/14.
//  Copyright © 2020 nhn. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TCGBAuthWeiboToken : NSObject

@property (nonatomic, strong) NSString* accessToken;
@property (nonatomic, strong) NSString* refreshToken;
@property (nonatomic, strong) NSString* uid;
@property (assign) long expireTime;
@property (assign) long updatedTime;

+ (instancetype)weiboTokenWithAccessToken:(NSString *)accessToken refreshToken:(NSString *)refreshToken uid:(NSString *)uid expireTime:(long)expireTime;
+ (instancetype)weiboTokenWithAccessToken:(NSString *)accessToken refreshToken:(NSString *)refreshToken uid:(NSString *)uid expireTime:(long)expireTime updatedTime:(long)updatedTime;
+ (instancetype)weiboTokenWithUserInfo:(NSDictionary *)userInfo;
- (NSString *)jsonString;

@end

NS_ASSUME_NONNULL_END
