﻿#pragma once

#include "CoreMinimal.h"
#include "NhnWebViewType.h"
#include "NhnWebViewConfiguration.generated.h"

USTRUCT()
struct NHNWEBVIEW_API FNhnWebViewConfiguration
{
    GENERATED_BODY()
    
    UPROPERTY()
    FString Title;
    
    UPROPERTY()
    FColor TitleColor = FColor::White;

    UPROPERTY()
    bool NavigationBarVisible = true;
    
    UPROPERTY()
    FColor NavigationBarColor = FColor(18, 93, 230);

    UPROPERTY()
    FColor NavigationBarIconTintColor = FColor::White;
    
    UPROPERTY()
    int32 NavigationBarHeight = -1;
    
    UPROPERTY()
    bool ForwardButtonVisible = false;
    
    UPROPERTY()
    bool BackButtonVisible = true;
    
    UPROPERTY()
    bool NavigationButtonsAlwaysVisible = false;
    
    UPROPERTY()
    FColor BackgroundColor;

    UPROPERTY()
    FVector2D ViewportSize;

    UPROPERTY()
    FString Locale;

    UPROPERTY()
    FString PopupIcon;

    UPROPERTY()
    TEnumAsByte<ENhnWebViewType> Type = Window;
};
