#pragma once

namespace NhnCefWindowsWrapper
{
    using TCefInitialize = bool(*)(const char* Locale);
    using TCefCreateWeb = void(*)(int32 WebIndex, int32 X, int32 Y, int32 Width, int32 Height, void* Buffer, int32 Option);
    using TCefRemoveWeb = void(*)(int32 WebIndex);
    using TCefLoadWeb = void(*)(int32 WebIndex, const char* URL, bool bIsShowScrollbar);
    using TCefResizeWeb = void(*)(int32 WebIndex, void* Buffer, int32 Width, int32 Height);
    using TCefShowScrollbar = void(*)(int32 WebIndex, bool bIsShow);
    using TCefUpdateWeb = int32(*)(int32 WebIndex, char** URL, int32* AdditionalInfo);
    using TCefExitCef = void(*)();
    using TCefInputWeb = void(*)(int32 WebIndex, int32 Flags, int32 X, int32 Y);
    using TCefGoBackForwardHome = void(*)(int32 WebIndex, int32 Direction);
    using TCefCanGoBackForward = bool(*)(int32 WebIndex, int32 Direction);
    using TCefExecuteJavaScript = void(*)(int32 WebIndex, const char* JavaScript);
    using TCefReserveInvalidRedirectUrlSchemes = void(*)(const char* Schemes);
    using TCefSetDownloadCompleteOption = void(*)(int Option);
    using TCefSetDebugEnable = void(*)(bool bEnable);
    using TCefSetOnFocusedNodeChanged = void(*)(int32 WebIndex, OnFocusedNodeChangedDelegate Callback);
    using TCefSetOnKeyEvent = void(*)(int32 WebIndex, OnKeyEventDelegate Callback);
    using TCefSetOnImeCompositionRangeChanged = void(*)(int32 WebIndex, OnImeCompositionRangeChangedDelegate Callback);
    using TCefImeSetComposition = void(*)(int32 WebIndex, wchar_t* Text, int32 BeginIndex, int32 Length);
    using TCefImeCommitText = void(*)(int32 WebIndex, wchar_t* Text);
    using TCefImeFinishComposingText = void(*)(int32 WebIndex, bool bKeep_Selection);
    using TCefImeCancelComposition = void(*)(int32 WebIndex);
    using TCefGetCompositionBoundIndex = int32(*)(int32 WebIndex, int32 X, int32 Y);
    using TCefGetCompositionBoundSize = int32(*)(int32 WebIndex);
    using TCefGetCompositionBound = void(*)(int32 WebIndex, int32 BoundIndex, int32* X, int32* Y, int32* Width, int32* Height);
    using TCefSetPopupIcon = void(*)(int32 WebIndex, const char* popupIconPath);

    struct FFunctionList
    {
        TCefInitialize Initialize;
        TCefCreateWeb CreateWeb;
        TCefRemoveWeb RemoveWeb;
        TCefLoadWeb LoadWeb;
        TCefResizeWeb ResizeWeb;
        TCefShowScrollbar ShowScrollbar;
        TCefUpdateWeb UpdateWeb;
        TCefExitCef ExitCef;
        TCefInputWeb InputWeb;
        TCefGoBackForwardHome GoBackForwardHome;
        TCefCanGoBackForward CanGoBackForward;
        TCefExecuteJavaScript ExecuteJavaScript;
        TCefReserveInvalidRedirectUrlSchemes ReserveInvalidRedirectUrlSchemes;
        TCefSetDownloadCompleteOption SetDownloadCompleteOption;
        TCefSetDebugEnable SetDebugEnable;
        TCefSetOnFocusedNodeChanged SetOnFocusedNodeChanged;
        TCefSetOnKeyEvent SetOnKeyEvent;
        TCefSetOnImeCompositionRangeChanged SetOnImeCompositionRangeChanged;
        TCefImeSetComposition ImeSetComposition;
        TCefImeCommitText ImeCommitText;
        TCefImeFinishComposingText ImeFinishComposingText;
        TCefImeCancelComposition ImeCancelComposition;
        TCefGetCompositionBoundIndex GetCompositionBoundIndex;
        TCefGetCompositionBoundSize GetCompositionBoundSize;
        TCefGetCompositionBound GetCompositionBound;
        TCefSetPopupIcon SetPopupIcon;
    };
}
