﻿#pragma once

#include "CoreMinimal.h"
#include "Styling/NhnWebViewStyleSet.h"
#include "Widgets/SCompoundWidget.h"

class SNhnWebViewContent;

DECLARE_DELEGATE_OneParam(FWebViewCloseDelegate, int32);

class SNhnWebViewPopup final : public SCompoundWidget
{
public:
    SLATE_BEGIN_ARGS(SNhnWebViewPopup)
        : _StyleSet(&FNhnWebViewStyleSet::Get())
        , _ViewportSize(FVector2D::ZeroVector)
    {
    }
    SLATE_ARGUMENT(UGameViewportClient*, GameViewport)
    SLATE_ARGUMENT(const ISlateStyle*, StyleSet)
    SLATE_ARGUMENT(int32, WebIndex)
    SLATE_ARGUMENT(FVector2D, ViewportSize)
    SLATE_ARGUMENT(FColor, BackgroundColor)
    SLATE_EVENT(FWebViewCloseDelegate, OnCloseWebView)
    SLATE_END_ARGS()
    
    void Construct(const FArguments& InArgs);
    const SNhnWebViewContent& GetWebViewContent() const;
    
private:
    FReply OnCloseButtonClicked() const;

private:
    TWeakObjectPtr<UGameViewportClient> GameViewport;
    
    TSharedPtr<SNhnWebViewContent> WebViewContent;

    const ISlateStyle* StyleSet = nullptr;
    int32 WebIndex = -1;
};
