#include "SNhnWebViewPopup.h"

#include "NhnWebViewModule.h"
#include "SlateOptMacros.h"
#include "Widgets/Images/SImage.h"
#include "NhnWebViewSubsystem.h"
#include "SNhnWebViewContent.h"

BEGIN_SLATE_FUNCTION_BUILD_OPTIMIZATION

void SNhnWebViewPopup::Construct(const FArguments& InArgs)
{
    StyleSet = InArgs._StyleSet;
    WebIndex = InArgs._WebIndex;
    
    checkf(InArgs._GameViewport, TEXT("GameViewport is null."));
    GameViewport = InArgs._GameViewport;
    
    FVector2D CurrentViewportSize;
    if (InArgs._ViewportSize == FVector2D::ZeroVector)
    {
        GameViewport->GetViewportSize(CurrentViewportSize);
    }
    else
    {
        CurrentViewportSize = InArgs._ViewportSize;
    }

    const FVector2D ViewportSize(CurrentViewportSize.X, CurrentViewportSize.Y);

    constexpr float ButtonSize = 24;
    constexpr float SpaceSize = 8;
    constexpr float PaddingSize = ButtonSize + SpaceSize; 
    
    ChildSlot
        .VAlign(VAlign_Fill)
        .HAlign(HAlign_Fill)
        [
            SNew(SOverlay)
            + SOverlay::Slot()
            .HAlign(HAlign_Fill)
            .VAlign(VAlign_Fill)
            [
                SNew(SImage)
                    .Image(StyleSet->GetBrush("CefWebView.Background"))
                    .ColorAndOpacity(FLinearColor(InArgs._BackgroundColor))
            ]
            + SOverlay::Slot()
            [
                SNew(SBox)
                .VAlign(InArgs._ViewportSize.Y == 0.0f ? VAlign_Fill : VAlign_Center)
                .HAlign(InArgs._ViewportSize.Y == 0.0f ? HAlign_Fill : HAlign_Center)
                .WidthOverride(CurrentViewportSize.X)
                .HeightOverride(CurrentViewportSize.Y+PaddingSize * 2)
                .Padding(FMargin(0, SpaceSize, 0, PaddingSize))
                [
                    SNew(SVerticalBox)
                    + SVerticalBox::Slot()
                    .VAlign(VAlign_Top)
                    .HAlign(HAlign_Right)
                    .Padding(0, SpaceSize, -SpaceSize, 8)
                    .AutoHeight()
                    [
                        SNew(SButton)
                        .VAlign(VAlign_Top)
                        .HAlign(HAlign_Right)
                        .OnClicked(this, &SNhnWebViewPopup::OnCloseButtonClicked)
                        .ClickMethod(EButtonClickMethod::MouseDown)
                        .ButtonColorAndOpacity(FColor::Transparent)
                        .IsFocusable(false)
                        [
                            SNew(SImage)
                            .Image(StyleSet->GetBrush("CefWebView.ClosePopupButton.Image"))
                        ]
                    ]
                    + SVerticalBox::Slot()
                    .VAlign(VAlign_Fill)
                    .HAlign(HAlign_Fill)
                    [
                        SNew(SOverlay)
                        +SOverlay::Slot()
                        [
                            SAssignNew(WebViewContent, SNhnWebViewContent)
                            .ViewportSize(ViewportSize)
                        ]
                    ]
                ]
            ]
        ];
    
    WebViewContent.ToSharedRef().Get().SetWebView(WebIndex, SharedThis(this));
}

const SNhnWebViewContent& SNhnWebViewPopup::GetWebViewContent() const
{
    return *WebViewContent;
}

FReply SNhnWebViewPopup::OnCloseButtonClicked() const
{
    if (GameViewport.IsValid())
    {
        if (const UGameInstance* GameInstance = GameViewport->GetGameInstance())
        {
            if (const UNhnWebViewSubsystem* Subsystem = GameInstance->GetSubsystem<UNhnWebViewSubsystem>())
            {
                Subsystem->CloseWebView();
            }
        }
    }
    
    return FReply::Handled();
}

END_SLATE_FUNCTION_BUILD_OPTIMIZATION
