﻿#include "SNhnWebViewDialog.h"

#include "SlateOptMacros.h"
#include "Internal/NhnCefTypes.h"
#include "Widgets/Images/SImage.h"

BEGIN_SLATE_FUNCTION_BUILD_OPTIMIZATION

#define LOCTEXT_NAMESPACE "CefWebViewDialog"

namespace UIString
{
    const FText Ok = LOCTEXT("OK", "OK");
    const FText Cancel = LOCTEXT("Cancel", "Cancel");
}

void SNhnWebViewDialog::Construct(const FArguments& InArgs)
{
    Index = InArgs._Index;
    StyleSet = InArgs._StyleSet;

    OnCloseDialog = InArgs._OnCloseDialog;

    const bool IsCancelButton = InArgs._JsDialogType != CefJsDialogType::Alert;
    
    ChildSlot
        .VAlign(VAlign_Fill)
        .HAlign(HAlign_Fill)
        [
            SNew(SOverlay)
            + SOverlay::Slot()
            [
                SNew(SBox)
                .HAlign(HAlign_Fill)
                .VAlign(VAlign_Fill)
                [
                    SNew(SImage)
                    .Image(StyleSet->GetBrush("CefWebView.Background"))
                ]
            ]
            + SOverlay::Slot()
            [
                SNew(SOverlay)
                + SOverlay::Slot()
                .HAlign(HAlign_Center)
                .VAlign(VAlign_Center)
                [
                    SNew(SBox)
                    .WidthOverride(600.0f)
                    .HeightOverride(450.0f)
                    [
                        SNew(SImage)
                        .Image(StyleSet->GetBrush("CefWebView.Navigation.Background"))
                    ]
                ]
                + SOverlay::Slot()
                .HAlign(HAlign_Center)
                .VAlign(VAlign_Center)
                [
                    SNew(SVerticalBox)
                    +SVerticalBox::Slot()
                    .VAlign(VAlign_Top)
                    .HAlign(HAlign_Center)
                    .Padding(0, 140, 0, 0)
                    [
                        SNew(STextBlock)
                        .Text(FText::FromString(InArgs._JsDialogMessage))
                        .TextStyle(StyleSet, "CefWebView.Dialog.MessageText")
                    ]
                    +SVerticalBox::Slot()
                    .VAlign(VAlign_Bottom)
                    .HAlign(HAlign_Center)
                    .Padding(0, 80)
                    [
                        SNew(SHorizontalBox)
                        +SHorizontalBox::Slot()
                        .Padding(20, 10)
                        [
                            SNew(SBox)
                            .WidthOverride(180)
                            .HeightOverride(60)
                            [
                                SNew(SButton)
                                .OnClicked(this, &SNhnWebViewDialog::OnOkButtonClicked)
                                .ClickMethod(EButtonClickMethod::MouseDown)
                                .IsFocusable(false)
                                .ButtonStyle(StyleSet, "CefWebView.StandardButton")
                                .TextStyle(StyleSet, "CefWebView.SubTitleText")
                                .ContentPadding(5.f)
                                .Text(UIString::Ok)
                                .VAlign(VAlign_Center)
                                .HAlign(HAlign_Center)
                            ]
                        ]
                        +SHorizontalBox::Slot()
                        .Padding(20, 10)
                        [
                            SNew(SBox)
                            .WidthOverride(180)
                            .HeightOverride(60)
                            .Visibility(IsCancelButton ? EVisibility::Visible : EVisibility::Collapsed)
                            [
                                SNew(SButton)
                                .OnClicked(this, &SNhnWebViewDialog::OnCancelButtonClicked)
                                .ClickMethod(EButtonClickMethod::MouseDown)
                                .IsFocusable(false)
                                .ButtonStyle(StyleSet, "CefWebView.StandardButton")
                                .TextStyle(StyleSet, "CefWebView.SubTitleText")
                                .ContentPadding(5.f)
                                .Text(UIString::Cancel)
                                .VAlign(VAlign_Center)
                                .HAlign(HAlign_Center)
                            ]
                        ]   
                    ]
                ]
            ]
        ];
}

FReply SNhnWebViewDialog::OnOkButtonClicked() const
{   if (OnCloseDialog.IsBound())
    {
        OnCloseDialog.Execute(Index, true);
    }
    
    return FReply::Handled();
}

FReply SNhnWebViewDialog::OnCancelButtonClicked() const
{
    if (OnCloseDialog.IsBound())
    {
        OnCloseDialog.Execute(Index, false);
    }
    
    return FReply::Handled();
}

END_SLATE_FUNCTION_BUILD_OPTIMIZATION
