﻿#include "NhnWebViewPluginInfo.h"

#include "NhnWebViewDefines.h"
#include "Interfaces/IPluginManager.h"

namespace NhnWebViewPluginInfo
{
    const FName PluginName = TEXT("NHNWebView");
}

FString NhnWebViewPluginInfo::GetPluginVersion()
{
    const TSharedPtr<IPlugin> Plugin = IPluginManager::Get().FindPlugin(PluginName.ToString());
    if (Plugin.IsValid() == false)
    {
        NHNWEBVIEW_LOG_WARNING("NhnWebView plugin is not loaded");
        
        static const FString UnknownString = TEXT("UNKNOWN");
        return UnknownString;
    }
    
    return Plugin->GetDescriptor().VersionName;
}

FString NhnWebViewPluginInfo::GetBinariesPath()
{
    const FString PluginDir = IPluginManager::Get().FindPlugin(PluginName.ToString())->GetBaseDir();

    return FPaths::Combine(PluginDir, TEXT("Binaries"), FPlatformProcess::GetBinariesSubdirectory());
}

FString NhnWebViewPluginInfo::GetContentPath()
{
    return IPluginManager::Get().FindPlugin(PluginName.ToString())->GetContentDir();
}