﻿#pragma once

#include "INhnCefNativeInvoker.h"
#include "Internal/NhnCefWebView.h"
#include "Modules/ModuleManager.h"

using FNhnLibraryCallerPtr = TSharedPtr<INhnCefNativeInvoker, ESPMode::ThreadSafe>;
using FNhnLibraryCallerRef = TSharedRef<INhnCefNativeInvoker, ESPMode::ThreadSafe>;

class FNhnWebViewModule final : public IModuleInterface
{
public:
    static FNhnWebViewModule& Get();
    
    virtual void StartupModule() override;
    virtual void ShutdownModule() override;

    void Initialize(const FString& Locale, const FCefWebViewResultDelegate& Callback);
    bool IsInitialized() const;

    void CreateWebView(const FCreateParams& Configuration, const FCefWebViewDelegateWebViewInfo& Callback);
    void ShowWebView(const FShowParams& Params);

    void HideWebView(const int32 WebIndex, const FCefWebViewResultDelegate& Callback);
    void RemoveWebView(const int32 WebIndex, const FCefWebViewResultDelegate& Callback);

    void ResizeWebView(const int32 WebIndex, const int32 Width, const int32 Height, const FCefWebViewResultDelegate& Callback);
    void ShowScrollBar(const int32 WebIndex, bool bIsShow, const FCefWebViewResultDelegate& Callback);

    void GoHome(const int32 WebIndex, const FCefWebViewResultDelegate& Callback);
    void GoBack(const int32 WebIndex, const FCefWebViewResultDelegate& Callback);
    bool CanGoBack(const int32 WebIndex);
    void GoForward(const int32 WebIndex, const FCefWebViewResultDelegate& Callback);
    bool CanGoForward(const int32 WebIndex);

    void ExecuteJavaScript(const int32 WebIndex, const FString& JavaScript, const FCefWebViewResultDelegate& Callback);
    void SetInvalidRedirectUrlScheme(TArray<FString> SchemeList, const FCefWebViewResultDelegate& Callback);
    void SetDownloadCompleteOption(int Option);
    
    void SetDebugEnable(bool bEnable);
    
    void InputWeb(const int32 WebIndex, const int32 Flags, const int32 X, const int32 Y);
    

    int32 AddWebView();
    void RemoveWebView(const int32 WebIndex);
    
    TSharedPtr<FNhnCefWebView> GetWebView(const int32 WebIndex) const;
    int32 GetWebViewIndex(const TSharedPtr<FNhnCefWebView>& FindWebView) const;
    int32 GetWebViewCount() const;

    FNhnLibraryCallerRef GetCaller() const
    {
        return Caller.ToSharedRef();
    }

private:
    bool CanInvoke(const FCefWebViewResultDelegate& Callback, const int32 WebIndex) const;
    bool IsInitialize(const FCefWebViewResultDelegate& Callback) const;
    bool HasWebView(const int32 WebIndex, const FCefWebViewResultDelegate&Callback) const;
    
private:
    FNhnLibraryCallerPtr Caller;
    bool bIsInitialized = false;
    
    int32 Index = 0;
    TMap<int32, TSharedPtr<FNhnCefWebView>> WebViewDictionary;
};

inline FNhnWebViewModule& FNhnWebViewModule::Get()
{
    return FModuleManager::LoadModuleChecked<FNhnWebViewModule>("NHNWebView");
}
