// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "NhnWebViewCallback.h"
#include "Internal/NhnCefResponseVo.h"

class UNhnWebViewSubsystem;
class SNhnWebView;
class SNhnWebViewPopup;
class SNhnWebViewDialog;
struct FNhnWebViewConfiguration;
struct FNhnWebViewEventListener;

struct FNhnWebViewInformation
{
    int32 WebIndex;
    TSharedPtr<SNhnWebView> WebViewSlate;
    TSharedPtr<SNhnWebViewPopup> WebViewPopupSlate;
    TSharedPtr<SNhnWebViewDialog> JsDialogSlate;

    explicit FNhnWebViewInformation(const int32 InWebIndex) : WebIndex(InWebIndex) {}
};

class FNhnWebViewManager : public TSharedFromThis<FNhnWebViewManager>
{
public:
    explicit FNhnWebViewManager(const TWeakObjectPtr<UNhnWebViewSubsystem>& Subsystem);
    ~FNhnWebViewManager();

    void ShowWebView(const FString& Url, const FNhnWebViewConfiguration& Configuration, const FNhnWebViewEventListener& EventParams = {});
    void CloseWebView(bool bIsExit = false);
    bool ExistWebView() const;

private:
    void OnCloseWebView(const int32 Index);
    void OnCloseDialog(const int32 Index, const bool bIsOkay);
    
    const FNhnWebViewInformation* CreateWebView(const int32 WebIndex, const FNhnWebViewConfiguration& InConfiguration);
    bool RemoveWebView(const int32 Index, bool bIsExit = false);

    void OpenDialog(const int32 Index, const NhnCef::FJsDialog& Dialog);

    int32 GetNextOrder();

private:
    TWeakObjectPtr<UNhnWebViewSubsystem> Subsystem;
    
    TMap<int32, FNhnWebViewInformation> WebViewContainer;
    int32 ZOrder;
    FNhnWebViewErrorDelegate CloseCallback;
    TArray<FString> SchemeList;
    FNhnWebViewSchemeDelegate SchemeEvent;
};
