
#include "NhnWebViewImeHandler.h"
#include "GenericPlatform/ITextInputMethodSystem.h"
#include "NhnWebViewModule.h"
#include "NhnWebViewTextInputMethodContext.h"

FNhnWebViewImeHandler* GCEFWebViewImeHandlerRef = nullptr;

void OnFocusedNodeChanged(const bool bIsFocus)
{
    if (GCEFWebViewImeHandlerRef != nullptr)
    {
        GCEFWebViewImeHandlerRef->HandleFocusChangedMessage(bIsFocus);    
    }
}

FNhnWebViewImeHandler::FNhnWebViewImeHandler()
{
    GCEFWebViewImeHandlerRef = this;
    TextInputMethodSystem = nullptr;
    WebIndex = 0;
    bIsInitContext = false;
    bIsDeactivateContext = false;
}

FNhnWebViewImeHandler::~FNhnWebViewImeHandler()
{
    FNhnWebViewModule::Get().GetCaller()->SetOnFocusedNodeChanged(WebIndex, nullptr);
    GCEFWebViewImeHandlerRef = nullptr;
}

void FNhnWebViewImeHandler::UnbindCefBrowser()
{
    if (TextInputMethodContext.IsValid())
    {
        DestroyContext();
    }
}

void FNhnWebViewImeHandler::SetWebView(const TSharedPtr<SWidget> SlateWidget, const uint32 InWebIndex)
{
    InternalBrowserSlateWidget = SlateWidget;
    WebIndex = InWebIndex;

    FNhnWebViewModule::Get().GetCaller()->SetOnFocusedNodeChanged(WebIndex, OnFocusedNodeChanged);
}

void FNhnWebViewImeHandler::AbortComposition() const
{
    if (WebIndex > 0)
    {
        FNhnWebViewModule::Get().GetCaller()->ImeCancelComposition(WebIndex);
    }
}

void FNhnWebViewImeHandler::SetFocus(const bool bHasFocus) const
{
    if (!TextInputMethodSystem || !TextInputMethodContext.IsValid())
    {
        return;
    }

    if (bHasFocus)
    {
        TextInputMethodSystem->ActivateContext(TextInputMethodContext.ToSharedRef());
    }
    else
    {
        DeactivateContext();
    }
}

void FNhnWebViewImeHandler::UpdateCachedGeometry(const FGeometry& AllottedGeometry) const
{
    if (TextInputMethodContext.IsValid() && TextInputMethodContext->UpdateCachedGeometry(AllottedGeometry))
    {
        if (TextInputMethodChangeNotifier.IsValid())
        {
            TextInputMethodChangeNotifier->NotifyLayoutChanged(ITextInputMethodChangeNotifier::ELayoutChangeType::Changed);
        }
    }
}

void FNhnWebViewImeHandler::CEFCompositionRangeChanged(const bool bIsRangeChanged) const
{
    if (TextInputMethodContext.IsValid() && TextInputMethodContext->CEFCompositionRangeChanged(bIsRangeChanged))
    {
        if (TextInputMethodChangeNotifier.IsValid())
        {
            TextInputMethodChangeNotifier->NotifyLayoutChanged(ITextInputMethodChangeNotifier::ELayoutChangeType::Changed);
        }
    }
}

void FNhnWebViewImeHandler::UpdateImeHandler(const bool bIsImeChanged)
{
    if (bIsImeChanged == true)
    {
        InitContext();
    }
    else
    {
        DestroyContext();
    }
}

void FNhnWebViewImeHandler::BindInputMethodSystem(ITextInputMethodSystem* InTextInputMethodSystem)
{
    TextInputMethodSystem = InTextInputMethodSystem;

    if (TextInputMethodSystem && TextInputMethodContext.IsValid())
    {
        TextInputMethodChangeNotifier = TextInputMethodSystem->RegisterContext(TextInputMethodContext.ToSharedRef());
    }
}

void FNhnWebViewImeHandler::UnbindInputMethodSystem()
{
    if (TextInputMethodContext.IsValid())
    {
        DestroyContext();
    }
    TextInputMethodSystem = nullptr;
}

void FNhnWebViewImeHandler::InitContext()
{
    if (TextInputMethodSystem == nullptr)
    {
        return;
    }

    // Clean up any existing context
    DestroyContext();

    TextInputMethodContext = FNhnWebViewTextInputMethodContext::Create(SharedThis(this), WebIndex);
    if (TextInputMethodSystem != nullptr)
    {
        TextInputMethodChangeNotifier = TextInputMethodSystem->RegisterContext(TextInputMethodContext.ToSharedRef());
    }
    if (TextInputMethodChangeNotifier.IsValid() == true)
    {
        TextInputMethodChangeNotifier->NotifyLayoutChanged(ITextInputMethodChangeNotifier::ELayoutChangeType::Created);
    }

    TextInputMethodSystem->ActivateContext(TextInputMethodContext.ToSharedRef());
}

void FNhnWebViewImeHandler::DeactivateContext() const
{
    if (TextInputMethodSystem == nullptr || TextInputMethodContext.IsValid() == false)
    {
        return;
    }

    const TSharedRef<FNhnWebViewTextInputMethodContext> TextInputMethodContextRef = TextInputMethodContext.ToSharedRef();
    if (TextInputMethodSystem->IsActiveContext(TextInputMethodContextRef))
    {
        // Make sure that the composition is aborted to avoid any IME calls to EndComposition from trying to mutate our dying owner widget
        if (TextInputMethodContextRef->IsComposing() == true)
        {
            TextInputMethodContextRef->AbortComposition();
            if (TextInputMethodChangeNotifier.IsValid() == true)
            {
                TextInputMethodChangeNotifier->CancelComposition();
            }
        }
        TextInputMethodSystem->DeactivateContext(TextInputMethodContextRef);
    }
}

void FNhnWebViewImeHandler::DestroyContext()
{
    if (TextInputMethodContext.IsValid() == false)
    {
        return;
    }

    if (TextInputMethodSystem != nullptr)
    {
        DeactivateContext();
        TextInputMethodSystem->UnregisterContext(TextInputMethodContext.ToSharedRef());
    }

    TextInputMethodChangeNotifier.Reset();
    TextInputMethodContext.Reset();
}

bool FNhnWebViewImeHandler::HandleFocusChangedMessage(const bool bIsEditable)
{
    if (bIsEditable == false)
    {
        if (TextInputMethodContext.IsValid())
        {
            bIsDeactivateContext = true;
        }
    }
    else
    {
        bIsInitContext = true;
    }

    return true;
}

void FNhnWebViewImeHandler::UpdateFocusChangedContext()
{
    if (bIsInitContext == true)
    {
        bIsInitContext = false;
        InitContext();
    }

    if (bIsDeactivateContext == true)
    {
        bIsDeactivateContext = false;
        DeactivateContext();
    }
}