// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "NhnCefRequestVo.h"
#include "NhnCefWebViewCallback.h"

using namespace NhnCef;

class FNhnCefWebView final
{
public:
    FNhnCefWebView();
    ~FNhnCefWebView();

    void CreateWebView(const int32 InWebIndex, const FCreateParams& Params, const FCefWebViewDelegateWebViewInfo& Callback);
    void ShowWebView(const FShowParams& Params);

    void HideWebView();
    void ResizeWebView(const int32 Width, const int32 Height);
    void ShowScrollBar(const bool bShow) const;
    static void InputWeb(const int32 WebIndex, const int32 Flags, const int32 X, const int32 Y);

    void GoHome() const;
    bool CanGoBack() const;
    void GoBack() const;
    bool CanGoForward() const;
    void GoForward() const;

    void ExecuteJavaScript(const FString JavaScript) const;
    
    static void ReserveInvalidRedirectUrlSchemes(const FString Schemes);
    static void SetDownloadCompleteOption(int Option);
    static void SetDebugEnable(bool bEnable);

    void DrawDefaultColor() const;

    void OpenDialog(int32 Type, FString Message) const;

    void SetPopupBlockMessage(FString Message);
    void OpenPopupBlock();

    void UpdateTexture();
    int32 EventLoop();
    void UpdateWebViewStatus(FString URL, int32 Status, int32 AdditionalInfo);

    UTexture2D* GetTexture() const;

protected:
    FCreateParams Configuration;

    int32 WebIndex;
    UTexture2D* Texture;
    TArray<uint8> TextureBuffer;
    bool bIsShow;

    FNhnCefWebViewUrlDelegate UrlCallback; // scheme callback
    FNhnCefWebViewTitleDelegate TitleCallback;
    FNhnCefWebViewInputFocusDelegate InputFocusCallback;
    FCefWebViewStatusDelegate WebStatusCallback;

    bool bIsWebUpdated;
    bool bIsWebFocus;
    bool bIsRendering;
    FString PopupBlockMessage;
};
