#pragma once

using OnFocusedNodeChangedDelegate = void(*)(bool bIsFocus);
using OnKeyEventDelegate = bool(*)(int Type, unsigned int Modifiers, int KeyCode, wchar_t Character);
using OnImeCompositionRangeChangedDelegate = void(*)(bool bIsRangeChanged);

class INhnCefNativeInvoker
{
public:
    virtual ~INhnCefNativeInvoker() = default;
    
    virtual bool Initialize(const FString& Locale) = 0;
    virtual void CreateWeb(const int32 WebIndex, const int32 X, const int32 Y, const int32 Width, const int32 Height, void* Buffer, const int32 Option) = 0;
    virtual void RemoveWeb(const int32 WebIndex) = 0;
    virtual void LoadWeb(const int32 WebIndex, const FString URL, bool bIsShowScrollbar) = 0;
    virtual void ResizeWeb(const int32 WebIndex, void* Buffer, const int32 Width, const int32 Height) = 0;
    virtual void ShowScrollbar(const int32 WebIndex, const bool bIsShow) = 0;
    virtual int32 UpdateWeb(const int32 WebIndex, FString& URL, int32& AdditionalInfo) = 0;
    virtual void ExitCef() = 0;
    virtual void InputWeb(const int32 WebIndex, const int32 Flags, const int32 X, const int32 Y) = 0;
    virtual void GoBackForwardHome(const int32 WebIndex, const int32 Direction) = 0;
    virtual bool CanGoBackForward(const int32 WebIndex, const int32 Direction) = 0;
    virtual void ExecuteJavaScript(const int32 WebIndex, const FString JavaScript) = 0;
    virtual void ReserveInvalidRedirectUrlSchemes(const FString Schemes) = 0;
    virtual void SetDownloadCompleteOption(int Option) = 0;
    virtual void SetDebugEnable(bool bEnable) = 0;

    virtual void SetOnFocusedNodeChanged(const int32 WebIndex, const OnFocusedNodeChangedDelegate& Callback) = 0;
    virtual void SetOnKeyEvent(const int32 WebIndex, const OnKeyEventDelegate& Callback) = 0;
    virtual void SetOnImeCompositionRangeChanged(const int32 WebIndex, const OnImeCompositionRangeChangedDelegate& Callback) = 0;

    virtual void ImeSetComposition(const int32 WebIndex, const FString Text, const int32 BeginIndex, const int32 Length) = 0;
    virtual void ImeCommitText(const int32 WebIndex, const FString Text) = 0;
    virtual void ImeFinishComposingText(const int32 WebIndex, const bool bKeepSelection) = 0;
    virtual void ImeCancelComposition(const int32 WebIndex) = 0;
    virtual int32 GetCompositionBoundIndex(const int32 WebIndex, const int32 X, const int32 Y) = 0;
    virtual int32 GetCompositionBoundSize(const int32 WebIndex) = 0;
    virtual void GetCompositionBound(const int32 WebIndex, int32 BoundIndex, int32& X, int32& Y, int32& Width, int32& Height) = 0;
    virtual void SetPopupIcon(const int32 WebIndex, const FString& popupIconPath) = 0;
};