﻿using System;
using System.IO;
using System.Linq;
using UnrealBuildTool;

public class NHNWebView : ModuleRules
{
    public NHNWebView(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

        PublicDependencyModuleNames.AddRange(
            new[]
            {
                "Core"
            }
        );

        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "CoreUObject",
                "Engine",
                "Projects",
                "Slate",
                "SlateCore",
                "RHI",
                "RenderCore",
                "InputCore"
            }
        );
        
        if (Target.Platform == UnrealTargetPlatform.Win64)
        {
            string[] dlls =
            {
                "chrome_elf.dll",
                "d3dcompiler_47.dll",
                "libEGL.dll",
                "libGLESv2.dll",
                "nhncef.dll",
                "nlibcef.dll",
            };
            
            PublicDelayLoadDLLs.AddRange(dlls);
            
            var thirdPartyPath = Path.GetFullPath(Path.Combine(ModuleDirectory, "ThirdParty", Target.Platform.ToString()));
            var binariesPath = Path.GetFullPath(Path.Combine(PluginDirectory, "Binaries", Target.Platform.ToString()));
            
            foreach (var dll in dlls)
            {
                RuntimeDependencies.Add(Path.Combine(binariesPath, dll), Path.Combine(thirdPartyPath, dll));
            }
            
            var dependencyExtensions = new[] { ".pak", ".dat", ".bin", ".exe" };
            var dependencyFiles = Directory.EnumerateFiles(thirdPartyPath, "*.*", SearchOption.AllDirectories)
                .Where(file => dependencyExtensions.Any(ext => file.EndsWith(ext, StringComparison.OrdinalIgnoreCase)));

            foreach (var filePath in dependencyFiles)
            {
                RuntimeDependencies.Add(Path.Combine(binariesPath, GetRelativePath(thirdPartyPath, filePath)), filePath);
            }
            
            if (Target.bUsesSlate)
            {
                RuntimeDependencies.Add(Path.Combine(PluginDirectory, "Content", "Slate", "..."), StagedFileType.UFS);
            }
        }
        else
        {
            Console.WriteLine("{0} is not supported.", Target.Platform);
        }
    }
    
    private static string GetRelativePath(string baseDir, string filePath)
    {
        Uri baseUri = new Uri(baseDir.TrimEnd(Path.DirectorySeparatorChar) + Path.DirectorySeparatorChar);
        Uri fileUri = new Uri(filePath);
        return Uri.UnescapeDataString(baseUri.MakeRelativeUri(fileUri).ToString().Replace('/', Path.DirectorySeparatorChar));
    }
}
