#pragma once

#include "CoreMinimal.h"
#include "Templates/SharedPointer.h"
#include "Templates/UnrealTypeTraits.h"

namespace NHN {

template<typename... TTypes>
using TVoidType = void;

/**
 * Checks if a type is a member function pointer.
 */
template<typename T>
struct TIsMemberFunctionPointer
{
    enum { Value = std::is_member_function_pointer<T>::value };
    typedef T Type;
};

/**
 * Checks if a type is a TSharedPtr.
 */
template<typename T>
struct TIsSharedPtr
{
    enum { Value = false };
};
template<typename T, ESPMode Mode>
struct TIsSharedPtr<TSharedPtr<T, Mode>>
{
    enum { Value = true };
};

/**
 * Checks if a type has a FromJson member function.
 */
template<typename, typename = TVoidType<>>
struct THasFromJson
{
    enum { Value = false };
};

template<typename T>
struct THasFromJson<T, TVoidType<decltype(DeclVal<T>().FromJson(DeclVal<FString>()))>>
{
    enum { Value = true };
};

} // namespace NHN
