#pragma once

#include "NhnVariant.h"

class FNhnVariantArray
{
public:
    using FValueType = FNhnVariant;
    using FArrayType = TArray<FValueType>;

    FNhnVariantArray() = default;
    FNhnVariantArray(const FNhnVariantArray&) = default;
    FNhnVariantArray(FNhnVariantArray&&) = default;
    FNhnVariantArray& operator=(const FNhnVariantArray&) = default;
    FNhnVariantArray& operator=(FNhnVariantArray&&) = default;

    explicit FNhnVariantArray(const FArrayType& InArray) : Array(InArray) {}
    explicit FNhnVariantArray(FArrayType&& InArray) : Array(MoveTemp(InArray)) {}

    FNhnVariantArray(std::initializer_list<FValueType> InitList)
        : Array(InitList)
    {}

    FORCEINLINE void Add(const FValueType& Value) { Array.Add(Value); }
    FORCEINLINE void Add(FValueType&& Value) { Array.Add(MoveTemp(Value)); }
    FORCEINLINE int32 Num() const { return Array.Num(); }
    FORCEINLINE void Empty(const int32 Slack = 0) { Array.Empty(Slack); }
    FORCEINLINE void Reset() { Array.Reset(); }
    FORCEINLINE FValueType& operator[](const int32 Index) { return Array[Index]; }
    FORCEINLINE const FValueType& operator[](const int32 Index) const { return Array[Index]; }
    FORCEINLINE auto begin() { return Array.begin(); }
    FORCEINLINE auto end() { return Array.end(); }
    FORCEINLINE auto begin() const { return Array.begin(); }
    FORCEINLINE auto end() const { return Array.end(); }

    explicit operator FArrayType&() { return Array; }
    explicit operator const FArrayType&() const { return Array; }
    FArrayType& GetArray() { return Array; }
    const FArrayType& GetArray() const { return Array; }

    friend FArchive& operator<<(FArchive& Ar, FNhnVariantArray& InArray)
    {
        Ar << InArray.Array;
        return Ar;
    }

private:
    FArrayType Array;
};