#include "NhnVariantMap.h"

namespace NHN {
namespace Variant {

FString ToQueryToUrl(const FNhnVariantMap& Queries)
{
    FString LoginUrl;

    auto Process = [&LoginUrl](const FName& Key, const FNhnVariant& Value)
    {
        switch (Value.GetType())
        {
            case ENhnVariantType::Empty:
                break;
            case ENhnVariantType::Bool:
                LoginUrl += FString::Printf(TEXT("&%s=%s"), *Key.ToString(), Value.GetValue<bool>() ? TEXT("true") : TEXT("false"));
                break;
            case ENhnVariantType::Int32:
                LoginUrl += FString::Printf(TEXT("&%s=%d"), *Key.ToString(), Value.GetValue<int32>());
                break;
            case ENhnVariantType::Int64:
                LoginUrl += FString::Printf(TEXT("&%s=%lld"), *Key.ToString(), Value.GetValue<int64>());
                break;
            case ENhnVariantType::UInt32:
                LoginUrl += FString::Printf(TEXT("&%s=%u"), *Key.ToString(), Value.GetValue<uint32>());
                break;
            case ENhnVariantType::UInt64:
                LoginUrl += FString::Printf(TEXT("&%s=%llu"), *Key.ToString(), Value.GetValue<uint64>());
                break;
            case ENhnVariantType::Double:
                LoginUrl += FString::Printf(TEXT("&%s=%f"), *Key.ToString(), Value.GetValue<double>());
                break;
            case ENhnVariantType::Float:
                LoginUrl += FString::Printf(TEXT("&%s=%f"), *Key.ToString(), Value.GetValue<float>());
                break;
            case ENhnVariantType::String:
                LoginUrl += FString::Printf(TEXT("&%s=%s"), *Key.ToString(), *Value.GetValue<FString>());
                break;
            case ENhnVariantType::Name:
                LoginUrl += FString::Printf(TEXT("&%s=%s"), *Key.ToString(), *Value.GetValue<FName>().ToString());
                break;
            case ENhnVariantType::Array:
            case ENhnVariantType::Object:
                ensureMsgf(false, TEXT("Array/Object type cannot be converted to URL parameter: %s"), *Key.ToString());
                break;
            default:
                checkNoEntry();
                break;
        }
    };

    for (const auto& Query : Queries)
    {
        Process(Query.Key, Query.Value);
    }

    return LoginUrl;
}

} // namespace Variant
} // namespace NHN