#pragma once

#include "Serialization/JsonSerializerMacros.h"

struct FNhnValueObject
{
    virtual ~FNhnValueObject() {}

    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) = 0;

    FString ToJson()
    {
        FString JsonStr;
        {
            const TSharedRef<TJsonWriter<TCHAR, TCondensedJsonPrintPolicy<TCHAR>>> JsonWriter = TJsonWriterFactory<TCHAR, TCondensedJsonPrintPolicy<TCHAR>>::Create(&JsonStr);
            FJsonSerializerWriter<TCHAR, TCondensedJsonPrintPolicy<TCHAR>> Serializer(JsonWriter);
            Serialize(Serializer, false);
            JsonWriter->Close();
        }
        return JsonStr;
    }
    
    FString ToJson() const
    {
        return const_cast<FNhnValueObject*>(this)->ToJson();
    }

    FString ToPrettyJson()
    {
        FString JsonStr;
        {
            const TSharedRef<TJsonWriter<>> JsonWriter = TJsonWriterFactory<>::Create(&JsonStr);
            FJsonSerializerWriter<> Serializer(JsonWriter);
            Serialize(Serializer, false);
            JsonWriter->Close();
        }
        return JsonStr;
    }
    
    FString ToPrettyJson() const
    {
        return const_cast<FNhnValueObject*>(this)->ToPrettyJson();
    }

    bool FromJson(const FString& Json)
    {
        return FromJson(CopyTemp(Json));
    }
    
    bool FromJson(FString&& Json)
    {
        TSharedPtr<FJsonObject> JsonObject;
        const TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<>::Create(MoveTemp(Json));
        if (FJsonSerializer::Deserialize(JsonReader,JsonObject) && JsonObject.IsValid())
        {
            FJsonSerializerReader Serializer(JsonObject);
            Serialize(Serializer, false);
            return true;
        }
        return false;
    }

    bool FromJson(const TSharedPtr<FJsonObject> JsonObject)
    {
        if (JsonObject.IsValid())
        {
            FJsonSerializerReader Serializer(JsonObject);
            Serialize(Serializer, false);
            return true;
        }
        return false;
    }
};