#pragma once

struct FNhnValueObject;

using FNhnJsonSerializerBase = ::FJsonSerializerBase;
using FNhnJsonSerializable = ::FJsonSerializable;

template<typename... Args>
using TNhnJsonSerializerWriter = FJsonSerializerWriter<Args...>;

namespace NHN {
namespace Json {

template<typename T, typename = FNhnJsonSerializerBase>
TArray<T> ConvertJsonStringToJsonArray(const FString& JsonString)
{
    TArray<T> ResultArray;

    FString ConvertJsonString(JsonString);
    ConvertJsonString.RemoveFromStart(FString(TEXT("[")));
    ConvertJsonString.RemoveFromEnd(FString(TEXT("]")));
    
    TArray<FString> ConvertJsonItemStringArray;
    ConvertJsonString.ParseIntoArray(ConvertJsonItemStringArray, TEXT("},{"), true);
    
    for (const FString& Data : ConvertJsonItemStringArray)
    {
        FString OriginData(Data);
        if (Data.StartsWith(TEXT("{")) == false)
        {
            OriginData = TEXT("{") + OriginData;
        }
        if (Data.EndsWith(TEXT("}")) == false)
        {
            OriginData += TEXT("}");
        }
                    
        T ResponseData;
        ResponseData.FromJson(OriginData);
        
        ResultArray.Emplace(ResponseData);
    }

    return ResultArray;
}

template<typename T = FNhnValueObject>
FString ConvertJsonArrayToJsonString(const TArray<T>& JsonArray)
{
    TArray<TSharedPtr<FJsonValue>> JsonValues;

    for (const T& Element : JsonArray)
    {
        TSharedPtr<FJsonObject> JsonObject = MakeShared<FJsonObject>();
        TSharedRef<TJsonReader<>> JsonReader = TJsonReaderFactory<>::Create(Element.ToJson());

        if (FJsonSerializer::Deserialize(JsonReader, JsonObject) && JsonObject.IsValid())
        {
            JsonValues.Add(MakeShared<FJsonValueObject>(JsonObject));
        }
    }
    
    FString JsonString;
    const TSharedRef<TJsonWriter<TCHAR, TCondensedJsonPrintPolicy<TCHAR>>> Writer = TJsonWriterFactory<TCHAR, TCondensedJsonPrintPolicy<TCHAR>>::Create(&JsonString);
    FJsonSerializer::Serialize(JsonValues, Writer);

    return JsonString;
}

// FGamebaseVariant ConvertJsonToVariant(const TSharedPtr<FJsonValue>& JsonValue);
//
// GAMEBASECORE_API void DeserializeVariantMap(const FString& JsonName, FGamebaseVariantMap& VariantMap, FJsonSerializerBase& Serializer);
// GAMEBASECORE_API void SerializeVariantMap(const FString& JsonName, FGamebaseVariantMap& VariantMap, FJsonSerializerBase& Serializer);


} // namespace Json
} // namespace NHN