#include "NhnJsonUtilites.h"

#include "JsonObject.h"
#include "NhnVariantArray.h"
#include "NhnVariantMap.h"

namespace NHN {
namespace Json {

FNhnVariant ConvertJsonToVariant(const TSharedPtr<FJsonValue>& JsonValue)
{
    switch (JsonValue->Type)
    {
        case EJson::String:     return FNhnVariant(JsonValue->AsString());
        case EJson::Number:     return FNhnVariant(JsonValue->AsNumber());
        case EJson::Boolean:    return FNhnVariant(JsonValue->AsBool());
        case EJson::Array:
            {
                FNhnVariantArray ArrayVariants;
                for (const auto& Elem : JsonValue->AsArray())
                {
                    ArrayVariants.Add(ConvertJsonToVariant(Elem));
                }
                return FNhnVariant(ArrayVariants);
            }
        case EJson::Object:
            {
                const TSharedPtr<FJsonObject> JsonObj = JsonValue->AsObject();
                FNhnVariantMap MapVariant;
                for (const auto& Pair : JsonObj->Values)
                {
                    MapVariant.Add(FName(*Pair.Key), ConvertJsonToVariant(Pair.Value));
                }
                return FNhnVariant(MapVariant);
            }
        case EJson::Null:
        case EJson::None:
        default:
            return FNhnVariant();
    }
}

} // namespace Json
} // namespace NHN