﻿#pragma once

#include "CoreMinimal.h"
#include "GamebaseAdapterBase.h"
#include "GamebaseAuthTypes.h"
#include "GamebaseBaseTypes.h"
#include "GamebaseCoreAuthTypes.h"
#include "GamebaseStandaloneAuthTypes.h"
#include "GamebaseStandaloneAuthAdapter.generated.h"

class IGamebaseInternalData;

UCLASS(Abstract)
class GAMEBASESTANDALONE_API UGamebaseStandaloneAuthAdapter : public UGamebaseAdapterBase
{
    GENERATED_BODY()

public:
    using FLoginCallback = TFunction<void(const FGamebaseAuthCredentialsResult&)>;
    using FCancelLoginCallback = TFunction<void(const FGamebaseErrorResult&)>;
    using FLogoutCallback = TFunction<void()>;
    using FWithdrawCallback = TFunction<void()>;
    
    virtual void Initialize(const FGamebaseAuthConfiguration& Configuration);
    
    virtual void Login(const FGamebaseVariantMap& AdditionalInfo, const FLoginCallback& Callback)
        PURE_VIRTUAL(UGamebaseStandaloneAuthAdapter::Login,);
    
    virtual void CancelLogin(const FCancelLoginCallback& Callback);
    
    virtual void Logout(const FLogoutCallback& Callback)
        PURE_VIRTUAL(UGamebaseStandaloneAuthAdapter::Logout,);
    
    virtual void Withdraw(const FWithdrawCallback& Callback)
        PURE_VIRTUAL(UGamebaseStandaloneAuthAdapter::Withdraw,);
    
    virtual FString GetProviderName() const
        PURE_VIRTUAL(UGamebaseStandaloneAuthAdapter::GetProviderName, return {};);
    
    virtual FString GetUserID() const
        PURE_VIRTUAL(UGamebaseStandaloneAuthAdapter::GetUserID, return {};);
    
    virtual FString GetAccessToken() const
        PURE_VIRTUAL(UGamebaseStandaloneAuthAdapter::GetAccessToken, return {};);
    
    virtual FGamebaseAuthProviderProfilePtr GetProfile() const
        PURE_VIRTUAL(UGamebaseStandaloneAuthAdapter::GetProfile, return {};);

protected:
    virtual bool ShouldCollectWithKey() const override final { return true; }
    
protected:
    FGamebaseAuthConfiguration AuthConfiguration;
};

UENUM()
enum class EGamebaseStandaloneAuthMemberWebType
{
    WebView,
    ExternalBrowser
};

UCLASS(Abstract)
class GAMEBASESTANDALONE_API UGamebaseStandaloneAuthMemberWebAdapter : public UGamebaseStandaloneAuthAdapter
{
    GENERATED_BODY()

public:
    virtual void Initialize(const FGamebaseAuthConfiguration& Configuration) override final;
    virtual void Login(const FGamebaseVariantMap& AdditionalInfo, const FLoginCallback& Callback) override final;
    virtual void CancelLogin(const FCancelLoginCallback& Callback) override final;
    virtual void Logout(const FLogoutCallback& Callback) override final;
    virtual void Withdraw(const FWithdrawCallback& Callback) override final;
    
    virtual FString GetProviderName() const override final;
    virtual FString GetUserID() const override final;
    virtual FString GetAccessToken() const override final;
    virtual FGamebaseAuthProviderProfilePtr GetProfile() const override final;

    virtual FGamebaseVariantMap GetProviderSpecificQueries() const;
    virtual FGamebaseVariantMap GetProviderSpecificCredential() const;

    virtual EGamebaseStandaloneAuthMemberWebType GetViewType() const;
    
protected:
    void PerformLogin(const FGamebaseVariantMap& AdditionalInfo, const FLoginCallback& Callback);
    
private:
    FGamebaseLoginSystemPtr LoginSystem;
};

UCLASS(Abstract)
class GAMEBASESTANDALONE_API UGamebaseAuthCredentialsPolicy : public UObject
{
    GENERATED_BODY()

public:
    
};