#pragma once

enum class EGamebaseBrowserLaunchResult : uint8
{
    Opened = 0,
    Failed,
    Timeout,
    Closed,
    Cancelled
};

class FGamebaseGenericBrowserLauncher
{
public:
    using FLaunchCallback = TFunction<void(const EGamebaseBrowserLaunchResult, const FString&)>;
    using FShouldCloseCallback = TFunction<bool()>;
    
    struct FLaunchParams
    {
        FString Url;
        TOptional<float> Timeout;
        TOptional<TArray<FString>> MonitoringTag;
    };
    
    static void Launch(const FLaunchParams& Params, const FLaunchCallback& LaunchCallback, const FShouldCloseCallback& ShouldCloseCallback);
};
