#include "GamebaseGenericBrowserLauncher.h"

#include "GamebaseTimer.h"

void FGamebaseGenericBrowserLauncher::Launch(
    const FLaunchParams& Params,
    const FLaunchCallback& LaunchCallback,
    const FShouldCloseCallback& ShouldCloseCallback)
{
    FString Error;
    FPlatformProcess::LaunchURL(*Params.Url, nullptr, &Error);
    
    if (!Error.IsEmpty())
    {
        LaunchCallback(EGamebaseBrowserLaunchResult::Failed, Error);
        return;
    }
    
    if (Params.Timeout.IsSet() == false)
    {
        LaunchCallback(EGamebaseBrowserLaunchResult::Opened, {});
        return;
    }

    const float Timeout = Params.Timeout.GetValue();
    
    const auto TickerHandle = GamebaseTicker::AddTicker(FTickerDelegate::CreateLambda([LaunchCallback, ShouldCloseCallback](float DeltaTime) -> bool {
        if (ShouldCloseCallback && ShouldCloseCallback())
        {
            LaunchCallback(EGamebaseBrowserLaunchResult::Cancelled, {});
            return false;
        }

        return true;
    }), 1.0f);
    
    GamebaseTimer::AddTimer([LaunchCallback, TickerHandle, ShouldCloseCallback] {
        if (!TickerHandle.IsValid() || (ShouldCloseCallback && ShouldCloseCallback()))
        {
            return;
        }
        
        GamebaseTicker::RemoveTicker(TickerHandle);
        LaunchCallback(EGamebaseBrowserLaunchResult::Timeout, TEXT("External browser wait time has timed out"));
    }, Timeout);
}
