#pragma once

#include "GamebaseInternalResult.h"

using FGamebaseWebviewEventResult = FGamebaseInternalResult<FString>;
using FGamebaseWebViewEventCallback = TFunction<void(const FGamebaseWebviewEventResult&)>;
using FGamebaseWebViewCloseCallback = TFunction<void(const FGamebaseErrorResult&)>;
    
struct FGamebaseWebViewOpenParams
{
    enum WebviewType
    {
        Window,
        FloatingPopup,
    };
    
    struct FNavigation
    {
        FString Title;
        FColor TitleColor = FColor::White;
        FColor IconTintColor = FColor::White;
        FColor BarColor = FColor(18, 93, 230);
        int32 BarHeight = -1;
        bool bIsForwardButton = false;
        bool bIsBackButton = true;
        bool bVisibleButtons = false;
    };
        
    FString Url;
    TOptional<FNavigation> Navigation;
    FColor BackgroundColor;
    FVector2D ViewportSize = FVector2D::ZeroVector;
    TEnumAsByte<WebviewType> Type = Window;
    TArray<FString> SchemeList;
    FGamebaseWebViewCloseCallback CloseCallback;
    FGamebaseWebViewEventCallback EventCallback;
};