﻿#pragma once

#include "CoreMinimal.h"
#include "NhnJsonSerializable.h"
#include "Server/GamebaseServerPushResponse.h"

struct FGamebaseHeaderResponse final : FNhnJsonSerializable
{
    struct FTraceError final : FNhnJsonSerializable
    {
        FString ApiId;
        FString ApiVersion;
        FString AppId;
        FString GatewayApiVersion;
        FString ProductId;
        FString ThrowPoint;
        int32 ThrowPointErrorCode;
        int64 TrackingTime;
        FString Uri;
        int32 ResultCode;
        FString ResultMessage;
        FString InnerTraceError;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("apiId", ApiId);
            NHN_JSON_SERIALIZE("apiVersion", ApiVersion);
            NHN_JSON_SERIALIZE("appId", AppId);
            NHN_JSON_SERIALIZE("gatewayApiVersion", GatewayApiVersion);
            NHN_JSON_SERIALIZE("productId", ProductId);
            NHN_JSON_SERIALIZE("throwPoint", ThrowPoint);
            NHN_JSON_SERIALIZE("throwPointErrorCode", ThrowPointErrorCode);
            NHN_JSON_SERIALIZE("trackingTime", TrackingTime);
            NHN_JSON_SERIALIZE("uri", Uri);
            NHN_JSON_SERIALIZE("resultCode", ResultCode);
            NHN_JSON_SERIALIZE("resultMessage", ResultMessage);
            NHN_JSON_SERIALIZE_RAW_JSON_STRING("traceError", InnerTraceError);
        END_NHN_JSON_SERIALIZER
    };

    bool bIsSuccessful = false;
    int32 ResultCode;
    FString ResultMessage;
    FString TransactionId;
    TOptional<FTraceError> TraceError;
    TOptional<GamebaseServerPush::FServerPush> ServerPush;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("isSuccessful", bIsSuccessful);
        NHN_JSON_SERIALIZE("resultCode", ResultCode);
        NHN_JSON_SERIALIZE("resultMessage", ResultMessage);
        NHN_JSON_SERIALIZE("transactionId", TransactionId);
        NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("traceError", TraceError);
        NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("serverPush", ServerPush);
    END_NHN_JSON_SERIALIZER
};

struct FGamebaseWebSocketResponse final : FNhnJsonSerializable
{
    FGamebaseHeaderResponse Header;
    FString ServerPush;
    FString ServerPushPopup;
    FString Result;
    FString ErrorExtras;
    FString TransactionId;
    FString ApiId;
    
    FString OriginData;

    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
        NHN_JSON_SERIALIZE_RAW_JSON_STRING("errorExtras", ErrorExtras);
        NHN_JSON_SERIALIZE_RAW_JSON_STRING("serverPush", ServerPush);
        NHN_JSON_SERIALIZE_RAW_JSON_STRING("popup", ServerPushPopup);
        NHN_JSON_SERIALIZE("result", Result);
    END_NHN_JSON_SERIALIZER
};