﻿#pragma once

#include "CoreMinimal.h"
#include "NhnJsonSerializable.h"

struct FGamebaseBaseParameter : FNhnJsonSerializable
{
    virtual ~FGamebaseBaseParameter() override {}
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override {}
};

struct FGamebaseBasePayload : FNhnJsonSerializable
{
    virtual ~FGamebaseBasePayload() override {}
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override {}
};

struct IGamebaseWebSocketRequest : FNhnJsonSerializable
{
    virtual const FString& GetTransactionId() const = 0;
    virtual const FString& GetApiId() const = 0;
};

template <typename FParameterType = FGamebaseBaseParameter, typename FPayloadType = FGamebaseBasePayload>
struct TGamebaseWebSocketRequest final : IGamebaseWebSocketRequest
{
    TGamebaseWebSocketRequest(const FString& ProductId, const FString& ApiId, const FString& ApiVersion, const FString& AppId, const FString& AccessToken)
        : ProductId(ProductId)
        , ApiId(ApiId)
        , Version(ApiVersion)
        , AppId(AppId)
        , TransactionId(FGuid::NewGuid().ToString())
    {
        Headers.Add("X-TCGB-Transaction-Id", TransactionId);

        if (AccessToken.IsEmpty() == false)
        {
            Headers.Add("X-TCGB-Access-Token", AccessToken);
        }
    }

    virtual const FString& GetTransactionId() const override { return TransactionId; }
    virtual const FString& GetApiId() const override { return ApiId; }
    
    FString ProductId;
    FString ApiId;
    FString Version;
    FString AppId;
    TMap<FString, FString> Headers;
    FParameterType Parameters;
    FPayloadType Payload;
    FString TransactionId;

    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("productId", ProductId);
        NHN_JSON_SERIALIZE("apiId", ApiId);
        NHN_JSON_SERIALIZE("version", Version);
        NHN_JSON_SERIALIZE("appId", AppId);
        NHN_JSON_SERIALIZE_MAP("headers", Headers);
        NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("parameters", Parameters);
        NHN_JSON_SERIALIZE_OBJECT_STRING_SERIALIZABLE("payload", Payload);
        NHN_JSON_SERIALIZE("transactionId", TransactionId);
    END_NHN_JSON_SERIALIZER
};