#pragma once

#include "CoreMinimal.h"
#include "NhnJsonSerializable.h"
#include "WebSocket/GamebaseWebSocketResponse.h"

namespace GamebaseTerms
{
    struct FQueryTermsResponse final : FNhnJsonSerializable
    {
        struct FTerms final : FNhnJsonSerializable
        {
            struct FContent final : FNhnJsonSerializable
            {
                int32 TermsContentSeq;
                bool bAgreed;
                bool bRequired;
                FString Name;
                FString AgreePush;
                int32 Node1DepthPosition;
                int32 Node2DepthPosition;
                FString DetailPageUrl;
                
                BEGIN_NHN_JSON_SERIALIZER
                    NHN_JSON_SERIALIZE("termsContentSeq", TermsContentSeq);
                    NHN_JSON_SERIALIZE("agreed", bAgreed);
                    NHN_JSON_SERIALIZE("required", bRequired);
                    NHN_JSON_SERIALIZE("name", Name);
                    NHN_JSON_SERIALIZE("agreePush", AgreePush);
                    NHN_JSON_SERIALIZE("node1DepthPosition", Node1DepthPosition);
                    NHN_JSON_SERIALIZE("node2DepthPosition", Node2DepthPosition);
                    NHN_JSON_SERIALIZE("detailPageUrl", DetailPageUrl);
                END_NHN_JSON_SERIALIZER
            };

            int32 TermsSeq;
            FString TermsVersion;
            FString TermsCountryType;
            TArray<FContent> Contents;
        
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("termsSeq", TermsSeq);
                NHN_JSON_SERIALIZE("termsVersion", TermsVersion);
                NHN_JSON_SERIALIZE("termsCountryType", TermsCountryType);
                NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("contents", Contents, FContent);
            END_NHN_JSON_SERIALIZER
        };
        
        FGamebaseHeaderResponse Header;
        FTerms Terms;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("terms", Terms);
        END_NHN_JSON_SERIALIZER
    };

    struct FUpdateTermsResponse final : FNhnJsonSerializable
    {
        FGamebaseHeaderResponse Header;

        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
        END_NHN_JSON_SERIALIZER
    };
}
