﻿#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseTerms
{
    struct FQueryParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        FString UsimCountryCode;
        FString DeviceCountryCode;
        FString DeviceLanguage;
        FString DisplayLanguage;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("userId", UserId);
            NHN_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
            NHN_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
            NHN_JSON_SERIALIZE_STRING("deviceLanguage", DeviceLanguage);
            NHN_JSON_SERIALIZE_STRING("displayLanguage", DisplayLanguage);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FUpdateParameters final : FGamebaseBaseParameter
    {
        FString UserId;
        int32 TermsSeq;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("userId", UserId);
            NHN_JSON_SERIALIZE("termsSeq", TermsSeq);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FUpdatePayload final : FGamebaseBasePayload
    {
        struct FContent final : FNhnJsonSerializable
        {
            int32 TermsContentSeq;
            bool bAgreed;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("termsContentSeq", TermsContentSeq);
                NHN_JSON_SERIALIZE("agreed", bAgreed);
            END_NHN_JSON_SERIALIZER
        };

        TArray<FContent> Contents;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("contents", Contents, FContent);
        END_NHN_JSON_SERIALIZER
    };
}