#pragma once

#include "CoreMinimal.h"
#include "NhnJsonSerializeMacros.h"

namespace GamebaseServerPush
{
    struct FServerPush final : FNhnJsonSerializable
    {
        FString Type;
        FString Version;
        FString Stamp;
        bool Disconnect;
        bool StopHeartbeat;
        bool Logout;
        bool Popup;

        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("type", Type);
            NHN_JSON_SERIALIZE("version", Version);
            NHN_JSON_SERIALIZE("stamp", Stamp);
            NHN_JSON_SERIALIZE("disconnect", Disconnect);
            NHN_JSON_SERIALIZE("stopHeartbeat", StopHeartbeat);
            NHN_JSON_SERIALIZE("logout", Logout);
            NHN_JSON_SERIALIZE("popup", Popup);
        END_NHN_JSON_SERIALIZER
    };
        
    struct FServerPushPopup final : FNhnJsonSerializable
    {
        struct FMessage final : FNhnJsonSerializable
        {
            FString Title;
            FString Message;
                
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("title", Title);
                NHN_JSON_SERIALIZE("message", Message);
            END_NHN_JSON_SERIALIZER
        };
            
        FString DefaultLanguage;
        TMap<FString, FMessage> Messages;
            
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("userId", DefaultLanguage);
            NHN_JSON_SERIALIZE_MAP_SERIALIZABLE("messages", Messages, FMessage);
        END_NHN_JSON_SERIALIZER
    };
}

using FGamebaseServerPushPopupInfo = GamebaseServerPush::FServerPushPopup;