#pragma once

#include "CoreMinimal.h"

namespace GamebaseServerInfo
{
    const FString ApiVersion{ TEXT("v1.3.4") };
    
    namespace Launching
    {
        const FString ProductId{ TEXT("launching") };

        namespace Id
        {
            const FString GetLaunching = "getLaunching";
            const FString GetLaunchingStatus = "getLaunchingStatus";
            const FString GetImageNotices = "getImageNotices";
        }
    }

    namespace Gateway
    {
        const FString ProductId{ TEXT("gateway") };

        namespace Id
        {
            const FString IdpLogin = "idPLogin";
            const FString TokenLogin = "tokenLogin";
            const FString BindIdPToken = "bindIdPToken";
            const FString Withdraw = "withdraw";
            const FString Logout = "logout";
            const FString RemoveMapping = "removeMapping";
            const FString AddMapping = "addMapping";
            const FString AddMappingForcibly = "addMappingForcibly";
            const FString IssueShortTermTicket = "issueShortTermTicket";
            const FString IssueShortTermTicketWithoutLogin = "issueShortTermTicketWithoutLogin";
            const FString IntrospectAccessToken = "introspectAccessToken";
            const FString HealthCheck = "healthCheck";
            const FString TemporaryWithdrawal = "temporaryWithdrawal";
            const FString CancelTemporaryWithdrawal = "cancelTemporaryWithdrawal";
            const FString IssueSessionTicket = "issueSessionTicket";
            const FString ExchangeSession = "exchangeSession";
            const FString DeleteSessionTicket = "deleteSessionTicket";
        }
    }

    namespace Presence
    {
        const FString ProductId{ TEXT("presence") };

        namespace Id
        {
            const FString Heartbeat = "heartbeat";
            const FString SetUserMeta = "setUserMeta";
            const FString CompletePurchase = "completePurchase";
        }
    }
    
    namespace TOS
    {
        const FString ProductId{ TEXT("tos") };

        namespace Id
        {
            const FString QueryTerms = "queryTerms";
            const FString UpdateTerms = "updateTerms";
        }
    }

    namespace IapBackend
    {
        const FString ProductId{ TEXT("iap-backend")};

        namespace Id
        {
            const FString GetGamebaseProducts = "getGamebaseProducts";
            const FString GetProductWithGamebaseProductId = "getProductWithGamebaseProductId";
            const FString GetProductsWithMarketItemId = "getProductsWithMarketItemId";
        }
    }
}