﻿#pragma once

#include "CoreMinimal.h"
#include "GamebaseTicker.h"

class FGamebaseScheduler
{
public:
    explicit FGamebaseScheduler(const float InIntervalTime);
    virtual ~FGamebaseScheduler();

    void StartScheduler();
    void StopScheduler();

protected:
    virtual void OnStartSchedule() {}
    virtual void OnStopSchedule() {}
    virtual void OnUpdateSchedule() {}

private:
    bool Tick(float DeltaTime);
    
protected:
    float IntervalTime;
    
private:
    FTimerHandle OnUpdateScheduleHandle;
    FGamebaseTickerDelegateHandle TickDelegateHandle;
};
