﻿#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseHeartbeat
{
    struct FParameters final : FGamebaseBaseParameter
    {
        FString AppId;

        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("appId", AppId);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FPayload final : FGamebaseBasePayload
    {
        FString AppId;
        FString UserId;
        FString ClientVersion;
        FString OSCode;
        FString DeviceCountryCode;
        FString UsimCountryCode;
        FString StoreCode;
        FString DeviceModel;
        FString IdpCode;
        FString ThirdIdPCode;
            
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("appId", AppId);
            NHN_JSON_SERIALIZE_STRING("userId", UserId);
            NHN_JSON_SERIALIZE_STRING("clientVersion", ClientVersion);
            NHN_JSON_SERIALIZE_STRING("osCode", OSCode);
            NHN_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
            NHN_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
            NHN_JSON_SERIALIZE_STRING("storeCode", StoreCode);
            NHN_JSON_SERIALIZE_STRING("deviceModel", DeviceModel);
            NHN_JSON_SERIALIZE_STRING("idPCode", IdpCode);
            NHN_JSON_SERIALIZE_STRING("thirdIdPCode", ThirdIdPCode);
        END_NHN_JSON_SERIALIZER
    };
}