#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketResponse.h"

namespace GamebasePurchase
{   
    struct FIapProductResponse final : FNhnJsonSerializable
    {
        FString MarketItemId;
        FString GamebaseProductId;
        FString GamebaseProductName;
        FString GamebaseProductType;
        bool bIsActive;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("marketItemId", MarketItemId);
            NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
            NHN_JSON_SERIALIZE("gamebaseProductName", GamebaseProductName);
            NHN_JSON_SERIALIZE("gamebaseProductType", GamebaseProductType);
            NHN_JSON_SERIALIZE("isActive", bIsActive);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FIapProductWithMarketItemIdResponse final : FNhnJsonSerializable
    {
        FString MarketItemId;
        FString GamebaseProductId;
        FString GamebaseProductName;
        bool bIsActive;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("marketItemId", MarketItemId);
            NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
            NHN_JSON_SERIALIZE("gamebaseProductName", GamebaseProductName);
            NHN_JSON_SERIALIZE("isActive", bIsActive);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FGetGamebaseProductsResponse final : FNhnJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        TArray<FIapProductWithMarketItemIdResponse> Products;
        TArray<FIapProductWithMarketItemIdResponse> InvalidProducts;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("products", Products, FIapProductWithMarketItemIdResponse);
            NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("invalidProducts", InvalidProducts, FIapProductWithMarketItemIdResponse);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FGetProductWithGamebaseProductIdResponse final : FNhnJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        FIapProductResponse Product;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("product", Product);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FGetProductsWithMarketItemIdResponse final : FNhnJsonSerializable
    {
        FGamebaseHeaderResponse Header;
        TArray<FIapProductWithMarketItemIdResponse> Products;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("products", Products, FIapProductWithMarketItemIdResponse);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FGamebasePayloadResponse final : FNhnJsonSerializable
    {
        FString StoreUserId;
        FString GamebaseProductId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("storeUserId", StoreUserId);
            NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
        END_NHN_JSON_SERIALIZER
    };
}
