#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebasePurchase
{
    struct FGetGamebaseProductsParameters final : FGamebaseBaseParameter
    {
        FString StoreCode;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("storeCode", StoreCode);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FGetProductWithGamebaseProductIdParameters final : FGamebaseBaseParameter
    {
        FString StoreCode;
        FString GamebaseProductId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("storeCode", StoreCode);
            NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FGetProductsWithMarketItemIdParameters final : FGamebaseBaseParameter
    {
        FString StoreCode;
        FString MarketItemId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("storeCode", StoreCode);
            NHN_JSON_SERIALIZE("marketItemId", MarketItemId);
        END_NHN_JSON_SERIALIZER
    };
}