#include "GamebasePurchaseDefines.h"

FString GamebasePurchase::GetHostUrl(const FString& Zone, const bool bIsSandbox)
{
    static const FString ZoneAlpha = TEXT("alpha");
    static const FString ZoneBeta = TEXT("beta");
    static const FString ZoneReal = TEXT("real");
    
    FString PrefixString;
    
    if (Zone.Equals(ZoneAlpha) || Zone.Equals(ZoneBeta))
    {
        PrefixString = Zone + TEXT("-");
    }
    else if (Zone.Equals(ZoneReal))
    {
        if (bIsSandbox)
        {
            PrefixString = TEXT("sandbox-");
        }
    }
        
    return FString::Printf(TEXT("https://%sgw-iap.nhncloudservice.com"), *PrefixString);
}
