#pragma once

#include "CoreMinimal.h"
#include "NhnJsonSerializable.h"

namespace GamebaseLaunching
{
    struct FErrorExtras final : FNhnJsonSerializable
    {
        FString UpdateInfo;
        FString Language;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_RAW_JSON_STRING("updateInfo", UpdateInfo);
            NHN_JSON_SERIALIZE_RAW_JSON_STRING("language", Language);
        END_NHN_JSON_SERIALIZER
    };

    struct FLanguageInfo final : FNhnJsonSerializable
    {
        FString DeviceLanguage;
        FString DefaultLanguage;
                
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("deviceLanguage", DeviceLanguage);
            NHN_JSON_SERIALIZE("defaultLanguage", DefaultLanguage);
        END_NHN_JSON_SERIALIZER
    };
}
