﻿#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketRequest.h"

namespace GamebaseLaunching
{
    struct FParameters final : FGamebaseBaseParameter
    {
        FString AppId;
        FString UserId;
        FString ClientVersion;
        FString SDKVersion;
        FString UUID;
        FString DeviceKey;
        FString OSCode;
        FString OSVersion;
        FString DeviceModel;
        FString DeviceLanguage;
        FString DisplayLanguage;
        FString DeviceCountryCode;
        FString UsimCountryCode;
        FString StoreCode;
        int64 LastCheckedNoticeTime;
        FString TermsVersion;
            
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("appId", AppId);
            NHN_JSON_SERIALIZE_STRING("userId", UserId);
            NHN_JSON_SERIALIZE_STRING("clientVersion", ClientVersion);
            NHN_JSON_SERIALIZE_STRING("sdkVersion", SDKVersion);
            NHN_JSON_SERIALIZE_STRING("uuid", UUID);
            NHN_JSON_SERIALIZE_STRING("deviceKey", DeviceKey);
            NHN_JSON_SERIALIZE_STRING("osCode", OSCode);
            NHN_JSON_SERIALIZE_STRING("osVersion", OSVersion);
            NHN_JSON_SERIALIZE_STRING("deviceModel", DeviceModel);
            NHN_JSON_SERIALIZE_STRING("deviceLanguage", DeviceLanguage);
            NHN_JSON_SERIALIZE_STRING("displayLanguage", DisplayLanguage);
            NHN_JSON_SERIALIZE_STRING("deviceCountryCode", DeviceCountryCode);
            NHN_JSON_SERIALIZE_STRING("usimCountryCode", UsimCountryCode);
            NHN_JSON_SERIALIZE_STRING("storeCode", StoreCode);
            NHN_JSON_SERIALIZE("lastCheckedNoticeTime", LastCheckedNoticeTime);
            NHN_JSON_SERIALIZE_STRING("termsVersion", TermsVersion);
        END_NHN_JSON_SERIALIZER
    };
}