#pragma once

#include "CoreMinimal.h"
#include "WebSocket/GamebaseWebSocketResponse.h"
#include "ImageNotice/GamebaseImageNoticeConstants.h"

namespace GamebaseImageNotice
{
    struct FResponse final : FNhnJsonSerializable
    {
        struct FImageNoticeWeb final : FNhnJsonSerializable
        {   
            struct FImageNoticeInfo final : FNhnJsonSerializable
            {
                struct FImageInfo final : FNhnJsonSerializable
                {
                    int32 Width;
                    int32 Height;
                    
                    BEGIN_NHN_JSON_SERIALIZER
                        NHN_JSON_SERIALIZE("width", Width);
                        NHN_JSON_SERIALIZE("height", Height);
                    END_NHN_JSON_SERIALIZER
                };
                
                int64 ImageNoticeId;
                TOptional<FString> Path;
                TOptional<FString> ClickScheme;
                FString ClickType;
                FString Theme;
                TOptional<FImageInfo> ImageInfo;
                
                BEGIN_NHN_JSON_SERIALIZER
                    NHN_JSON_SERIALIZE("imageNoticeId", ImageNoticeId);
                    NHN_JSON_SERIALIZE_OPTIONAL("path", Path);
                    NHN_JSON_SERIALIZE_OPTIONAL("clickScheme", ClickScheme);
                    NHN_JSON_SERIALIZE("clickType", ClickType);
                    NHN_JSON_SERIALIZE("theme", Theme);
                    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("imageInfo", ImageInfo);
                END_NHN_JSON_SERIALIZER
            };

            FString Type;
            FString Theme;
            bool bHasImageNotice;
            TOptional<int64> RollingImageNoticeId;
            TOptional<int64> NextPopupTimeMillis;
            FString Address;
            int32 FooterHeight;
            TOptional<TArray<FImageNoticeInfo>> PageList;
        
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE("type", Type);
                NHN_JSON_SERIALIZE("theme", Theme);
                NHN_JSON_SERIALIZE("hasImageNotice", bHasImageNotice);
                NHN_JSON_SERIALIZE_OPTIONAL("rollingImageNoticeId", RollingImageNoticeId);
                NHN_JSON_SERIALIZE_OPTIONAL("nextPopupTimeMillis", NextPopupTimeMillis);
                NHN_JSON_SERIALIZE("address", Address);
                NHN_JSON_SERIALIZE("footerHeight", FooterHeight);
                NHN_JSON_SERIALIZE_OPTIONAL_ARRAY_SERIALIZABLE("pageList", PageList, FImageNoticeInfo);
            END_NHN_JSON_SERIALIZER

            bool IsValidType() const
            {
                using namespace GamebaseImageNotice;
                return Type.Equals(ViewType::Rolling) || Type.Equals(ViewType::Popup);
            }

            bool IsValidRollingImageNoticeId() const
            {
                using namespace GamebaseImageNotice;
                return RollingImageNoticeId.IsSet() && RollingImageNoticeId.GetValue() != Info::InvalidTime;
            }
        };
        
        FGamebaseHeaderResponse Header;
        FImageNoticeWeb ImageNoticeWeb;

        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("header", Header);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("imageNoticeWeb", ImageNoticeWeb);
        END_NHN_JSON_SERIALIZER
    };
}
