﻿#pragma once

class FGamebaseImageNoticePreferences : public TSharedFromThis<FGamebaseImageNoticePreferences>
{
public:
    explicit FGamebaseImageNoticePreferences(const FString& AppId) : AppId(AppId) {}
    
    void Initialize();
    void AddNextPopupTime(int64 NoticeId, int64 NextPopupTimeMs);
    void UpdateNextTimeData(int64 NoticeId);
    
    bool ShouldHideUntilTimeForNoticeId(const int64 NoticeId) const;

private:
    void Save();

private:
    FString AppId;
    TMap<int64, int64> NextPopupTimeMap;
};