﻿#pragma once

#include "CoreMinimal.h"
#include "Server/GamebaseServerPushResponse.h"

class IGamebaseInternalData;
class IGamebaseDisplayLanguage;
struct FGamebaseLaunchingInfo;
struct FGamebaseLaunchingUpdateInfo;
struct FGamebaseBanInfo;
struct FGamebaseError;

namespace GamebaseSystemPopup
{
    using FCloseFunction = TFunction<void()>;

    void ShowLaunchingNotice(const IGamebaseDisplayLanguage& Language,  const FGamebaseLaunchingInfo& LaunchingInfo, const FCloseFunction& Callback);
    void ShowLaunchingStatus(const IGamebaseInternalData* InternalData, const IGamebaseDisplayLanguage& Language, const FGamebaseLaunchingInfo& LaunchingInfo, const FCloseFunction& Callback);

    void ShowUpdateRecommend(const IGamebaseDisplayLanguage& Language, const FGamebaseLaunchingInfo& LaunchingInfo, const FCloseFunction& Callback);
    void ShowUpdateRequire(const IGamebaseDisplayLanguage& Language, const FGamebaseLaunchingInfo& LaunchingInfo, const FCloseFunction& Callback);
    void ShowBlockUser(const IGamebaseDisplayLanguage& Language, const FGamebaseLaunchingInfo& LaunchingInfo, const FCloseFunction& Callback);
    void ShowServiceClosed(const IGamebaseDisplayLanguage& Language, const FGamebaseLaunchingInfo& LaunchingInfo, const FCloseFunction& Callback);
    void ShowMaintenance(const IGamebaseDisplayLanguage& Language, const FGamebaseLaunchingInfo& LaunchingInfo, const FCloseFunction& Callback);
    void ShowUnknownErrorPopup(const IGamebaseDisplayLanguage& Language, const uint32 StatusCode, const FCloseFunction& Callback);
    
    void ShowUnregisteredClient(const IGamebaseDisplayLanguage& Language, const FGamebaseLaunchingUpdateInfo& UpdateInfo, const FCloseFunction& Callback);
    
    void ShowBan(const IGamebaseDisplayLanguage& Language, const FGamebaseBanInfo& BanInfo, const FCloseFunction& Callback);
    void ShowHeartbeatBan(const IGamebaseDisplayLanguage& Language, const FCloseFunction& Callback);
    void ShowServerPushKickout(const IGamebaseInternalData* InternalData, const IGamebaseDisplayLanguage& Language, const FGamebaseServerPushPopupInfo& Popup, const FCloseFunction& Callback);
}