#include "GamebaseStandaloneSystemInfo.h"

#include "GamebaseDebugLogger.h"
#include "GamebaseInternalData.h"
#include "GamebaseSystemUtils.h"
#include "IGamebaseDisplayLanguage.h"

FGamebaseStandaloneSystemInfo::FGamebaseStandaloneSystemInfo(const FGamebaseInternalDataPtr& InternalData)
    : InternalData(InternalData)
{
}

void FGamebaseStandaloneSystemInfo::RequestLastLoggedInProvider(const FGamebaseLastLoggedInProviderDelegate& Callback) const
{
    const FString LastLoggedInProvider = GetLastLoggedInProvider();
    if (LastLoggedInProvider.IsEmpty())
    {
        Callback.ExecuteIfBound({}, nullptr);
        return;
    }
    
    Callback.ExecuteIfBound(LastLoggedInProvider, nullptr);
}

FString FGamebaseStandaloneSystemInfo::GetLastLoggedInProvider() const
{
    if (InternalData.IsValid() == false)
    {
        GAMEBASE_LOG_DEBUG("The Gamebase SDK must be initialized");
        return FString();
    }

    if (InternalData->IsLogin() == false)
    {
        GAMEBASE_LOG_DEBUG("Call this API after log in");
        return FString();
    }

    return InternalData->GetAuthToken()->Token.SourceIdpCode;
}

FString FGamebaseStandaloneSystemInfo::GetUserID() const
{
    if (InternalData.IsValid() == false)
    {
        GAMEBASE_LOG_DEBUG("The Gamebase SDK must be initialized");
        return FString();
    }
    
    if (InternalData->IsLogin() == false)
    {
        GAMEBASE_LOG_DEBUG("Call this API after log in");
        return FString();
    }

    return InternalData->GetUserId();
}

FString FGamebaseStandaloneSystemInfo::GetAccessToken() const
{
    if (InternalData.IsValid() == false)
    {
        GAMEBASE_LOG_DEBUG("The Gamebase SDK must be initialized");
        return FString();
    }

    if (InternalData->IsLogin() == false)
    {
        GAMEBASE_LOG_DEBUG("Call this API after log in");
        return FString();
    }

    return InternalData->GetAccessToken();
}

FString FGamebaseStandaloneSystemInfo::GetSDKVersion() const
{
    return GamebaseSystemUtils::GetPluginVersion();
}

bool FGamebaseStandaloneSystemInfo::IsSandbox() const
{
    if (InternalData.IsValid() == false || InternalData->IsInitialize() == false)
    {
        GAMEBASE_LOG_DEBUG("The Gamebase SDK must be initialized");
        return false;
    }
    
    const auto LaunchingInfo = InternalData->GetLaunchingInfo();
    return LaunchingInfo->Launching.App.TypeCode.Equals(TEXT("SANDBOX"), ESearchCase::IgnoreCase);
}

FString FGamebaseStandaloneSystemInfo::GetDisplayLanguageCode() const
{
    if (InternalData.IsValid() == false)
    {
        GAMEBASE_LOG_DEBUG("The Gamebase SDK must be initialized");
        return FString();
    }
    
    return InternalData->GetDisplayLanguageCode();
}

void FGamebaseStandaloneSystemInfo::SetDisplayLanguageCode(const FString& LanguageCode)
{
    if (InternalData.IsValid() == false)
    {
        GAMEBASE_LOG_DEBUG("The Gamebase SDK must be initialized");
        return;
    }

    InternalData->GetDisplayLanguage()->SetLanguageCode(LanguageCode);
}

FString FGamebaseStandaloneSystemInfo::GetDeviceLanguageCode() const
{
    return GamebaseSystemUtils::GetDeviceLanguage();
}

FString FGamebaseStandaloneSystemInfo::GetCarrierCode() const
{
    GAMEBASE_NOT_SUPPORT_API();
    return FString();
}

FString FGamebaseStandaloneSystemInfo::GetCarrierName() const
{
    GAMEBASE_NOT_SUPPORT_API();
    return FString();
}

FString FGamebaseStandaloneSystemInfo::GetCountryCode() const
{
    GAMEBASE_NOT_SUPPORT_API();
    return FString();
}

FString FGamebaseStandaloneSystemInfo::GetCountryCodeOfUSIM() const
{
    GAMEBASE_NOT_SUPPORT_API();
    return FString();
}

FString FGamebaseStandaloneSystemInfo::GetCountryCodeOfDevice() const
{
    return GamebaseSystemUtils::GetCountryCode();
}